/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery.procedures;

import java.util.Comparator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;

public class InstalledProtocolsProcedure
extends CallableProcedure.BasicProcedure {
    private static final String[] PROCEDURE_NAMESPACE = new String[]{"dbms", "cluster"};
    public static final String PROCEDURE_NAME = "protocols";
    private final Supplier<Stream<Pair<AdvertisedSocketAddress, ProtocolStack>>> clientInstalledProtocols;
    private final Supplier<Stream<Pair<SocketAddress, ProtocolStack>>> serverInstalledProtocols;

    public InstalledProtocolsProcedure(Supplier<Stream<Pair<AdvertisedSocketAddress, ProtocolStack>>> clientInstalledProtocols, Supplier<Stream<Pair<SocketAddress, ProtocolStack>>> serverInstalledProtocols) {
        super(ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName(PROCEDURE_NAMESPACE, PROCEDURE_NAME)).out("orientation", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("remoteAddress", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("applicationProtocol", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("applicationProtocolVersion", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out("modifierProtocols", (Neo4jTypes.AnyType)Neo4jTypes.NTString).description("Overview of installed protocols").build());
        this.clientInstalledProtocols = clientInstalledProtocols;
        this.serverInstalledProtocols = serverInstalledProtocols;
    }

    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) {
        Stream<Object[]> outbound = this.toOutputRows(this.clientInstalledProtocols, "outbound");
        Stream<Object[]> inbound = this.toOutputRows(this.serverInstalledProtocols, "inbound");
        return Iterators.asRawIterator(Stream.concat(outbound, inbound));
    }

    private <T extends SocketAddress> Stream<Object[]> toOutputRows(Supplier<Stream<Pair<T, ProtocolStack>>> installedProtocols, String orientation) {
        Comparator<Pair> connectionInfoComparator = Comparator.comparing(entry -> ((SocketAddress)entry.first()).getHostname()).thenComparing(entry -> ((SocketAddress)entry.first()).getPort());
        return installedProtocols.get().sorted(connectionInfoComparator).map(entry -> this.buildRow((Pair)entry, orientation));
    }

    private <T extends SocketAddress> Object[] buildRow(Pair<T, ProtocolStack> connectionInfo, String orientation) {
        SocketAddress socketAddress = (SocketAddress)connectionInfo.first();
        ProtocolStack protocolStack = (ProtocolStack)connectionInfo.other();
        return new Object[]{orientation, socketAddress.toString(), protocolStack.applicationProtocol().category(), (long)((Integer)protocolStack.applicationProtocol().implementation()).intValue(), this.modifierString(protocolStack)};
    }

    private String modifierString(ProtocolStack protocolStack) {
        return protocolStack.modifierProtocols().stream().map(Protocol::implementation).collect(Collectors.joining(",", "[", "]"));
    }
}

