/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.List;
import org.neo4j.causalclustering.handlers.DuplexPipelineWrapperFactory;
import org.neo4j.causalclustering.handlers.PipelineWrapper;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.LogProvider;

public class VoidPipelineWrapperFactory
implements DuplexPipelineWrapperFactory {
    public static final PipelineWrapper VOID_WRAPPER = new PipelineWrapper(){

        @Override
        public List<ChannelHandler> handlersFor(Channel channel) {
            return Collections.emptyList();
        }

        @Override
        public String name() {
            return "void";
        }
    };

    @Override
    public PipelineWrapper forServer(Config config, Dependencies dependencies, LogProvider logProvider, Setting<String> policyName) {
        VoidPipelineWrapperFactory.verifyNoEncryption(config, policyName);
        return VOID_WRAPPER;
    }

    @Override
    public PipelineWrapper forClient(Config config, Dependencies dependencies, LogProvider logProvider, Setting<String> policyName) {
        VoidPipelineWrapperFactory.verifyNoEncryption(config, policyName);
        return VOID_WRAPPER;
    }

    private static void verifyNoEncryption(Config config, Setting<String> policyName) {
        assert (config.get(policyName) == null) : "Unexpected SSL policy " + policyName;
    }
}

