/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class DatabaseName {
    private final String name;

    public DatabaseName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseName that = (DatabaseName)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Marshal
    extends SafeStateMarshal<DatabaseName> {
        @Override
        protected DatabaseName unmarshal0(ReadableChannel channel) throws IOException {
            return new DatabaseName(StringMarshal.unmarshal(channel));
        }

        @Override
        public void marshal(DatabaseName databaseName, WritableChannel channel) throws IOException {
            StringMarshal.marshal(channel, databaseName.name());
        }

        @Override
        public DatabaseName startState() {
            return null;
        }

        @Override
        public long ordinal(DatabaseName databaseName) {
            return databaseName == null ? 0L : 1L;
        }
    }
}

