/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.causalclustering.protocol.handshake.GateEvent;

@ChannelHandler.Sharable
public class MessageGate
extends ChannelDuplexHandler {
    private final Predicate<Object> gated;
    private List<GatedWrite> pending = new ArrayList<GatedWrite>();

    public MessageGate(Predicate<Object> gated) {
        this.gated = gated;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof GateEvent) {
            if (GateEvent.getSuccess().equals(evt)) {
                for (GatedWrite write : this.pending) {
                    ctx.write(write.msg, write.promise);
                }
                ctx.channel().pipeline().remove((ChannelHandler)this);
            }
            this.pending.clear();
            this.pending = null;
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (!this.gated.test(msg)) {
            ctx.write(msg, promise);
        } else if (this.pending != null) {
            this.pending.add(new GatedWrite(msg, promise));
        } else {
            promise.setFailure((Throwable)new RuntimeException("Gate failed and has been permanently closed."));
        }
    }

    static class GatedWrite {
        final Object msg;
        final ChannelPromise promise;

        GatedWrite(Object msg, ChannelPromise promise) {
            this.msg = msg;
            this.promise = promise;
        }
    }
}

