/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.buffer.ByteBuf;
import java.io.Flushable;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;

public class NetworkFlushableByteBuf
implements FlushableChannel {
    private final ByteBuf delegate;

    public NetworkFlushableByteBuf(ByteBuf byteBuf) {
        this.delegate = byteBuf;
    }

    public FlushableChannel put(byte value) {
        this.delegate.writeByte((int)value);
        return this;
    }

    public FlushableChannel putShort(short value) {
        this.delegate.writeShort((int)value);
        return this;
    }

    public FlushableChannel putInt(int value) {
        this.delegate.writeInt(value);
        return this;
    }

    public FlushableChannel putLong(long value) {
        this.delegate.writeLong(value);
        return this;
    }

    public FlushableChannel putFloat(float value) {
        this.delegate.writeFloat(value);
        return this;
    }

    public FlushableChannel putDouble(double value) {
        this.delegate.writeDouble(value);
        return this;
    }

    public FlushableChannel put(byte[] value, int length) {
        this.delegate.writeBytes(value, 0, length);
        return this;
    }

    public void close() {
    }

    public Flushable prepareForFlush() {
        return null;
    }

    public ByteBuf buffer() {
        return this.delegate;
    }
}

