/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.neo4j.causalclustering.messaging.ReconnectingChannel;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.stream.Streams;

public class ReconnectingChannels {
    private final ConcurrentHashMap<AdvertisedSocketAddress, ReconnectingChannel> lazyChannelMap = new ConcurrentHashMap();

    public int size() {
        return this.lazyChannelMap.size();
    }

    public ReconnectingChannel get(AdvertisedSocketAddress to) {
        return this.lazyChannelMap.get(to);
    }

    public ReconnectingChannel putIfAbsent(AdvertisedSocketAddress to, ReconnectingChannel timestampedLazyChannel) {
        return this.lazyChannelMap.putIfAbsent(to, timestampedLazyChannel);
    }

    public Collection<ReconnectingChannel> values() {
        return this.lazyChannelMap.values();
    }

    public void remove(AdvertisedSocketAddress address) {
        this.lazyChannelMap.remove(address);
    }

    public Stream<Pair<AdvertisedSocketAddress, ProtocolStack>> installedProtocols() {
        return this.lazyChannelMap.entrySet().stream().map(this::installedProtocolOpt).flatMap(Streams::ofOptional);
    }

    private Optional<Pair<AdvertisedSocketAddress, ProtocolStack>> installedProtocolOpt(Map.Entry<AdvertisedSocketAddress, ReconnectingChannel> entry) {
        return entry.getValue().installedProtocolStack().map(protocols -> Pair.of(entry.getKey(), (Object)protocols));
    }
}

