/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.net;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.ServerHandshakeFinishedEvent;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.collection.Pair;

@ChannelHandler.Sharable
public class InstalledProtocolHandler
extends ChannelInboundHandlerAdapter {
    private ConcurrentMap<SocketAddress, ProtocolStack> installedProtocols = new ConcurrentHashMap<SocketAddress, ProtocolStack>();

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ServerHandshakeFinishedEvent.Created) {
            ServerHandshakeFinishedEvent.Created created = (ServerHandshakeFinishedEvent.Created)evt;
            this.installedProtocols.put(created.advertisedSocketAddress, created.protocolStack);
        } else if (evt instanceof ServerHandshakeFinishedEvent.Closed) {
            ServerHandshakeFinishedEvent.Closed closed = (ServerHandshakeFinishedEvent.Closed)evt;
            this.installedProtocols.remove(closed.advertisedSocketAddress);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public Stream<Pair<SocketAddress, ProtocolStack>> installedProtocols() {
        return this.installedProtocols.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue()));
    }
}

