/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.causalclustering.messaging.MessageGate;
import org.neo4j.causalclustering.protocol.ClientNettyPipelineBuilder;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ServerNettyPipelineBuilder;
import org.neo4j.logging.Log;

public abstract class NettyPipelineBuilder<O extends ProtocolInstaller.Orientation, BUILDER extends NettyPipelineBuilder<O, BUILDER>> {
    static final String MESSAGE_GATE_NAME = "message_gate";
    static final String ERROR_HANDLER_TAIL = "error_handler_tail";
    static final String ERROR_HANDLER_HEAD = "error_handler_head";
    private final ChannelPipeline pipeline;
    private final Log log;
    private final List<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>();
    private Predicate<Object> gatePredicate;
    private Runnable closeHandler;
    private BUILDER self = this;

    NettyPipelineBuilder(ChannelPipeline pipeline, Log log) {
        this.pipeline = pipeline;
        this.log = log;
    }

    public static ClientNettyPipelineBuilder client(ChannelPipeline pipeline, Log log) {
        return new ClientNettyPipelineBuilder(pipeline, log);
    }

    public static ServerNettyPipelineBuilder server(ChannelPipeline pipeline, Log log) {
        return new ServerNettyPipelineBuilder(pipeline, log);
    }

    public abstract BUILDER addFraming();

    public BUILDER modify(ModifierProtocolInstaller<O> modifier) {
        modifier.apply(this);
        return this.self;
    }

    public BUILDER modify(List<ModifierProtocolInstaller<O>> modifiers) {
        modifiers.forEach(this::modify);
        return this.self;
    }

    public BUILDER add(String name, List<ChannelHandler> newHandlers) {
        newHandlers.stream().map(handler -> new HandlerInfo(name, (ChannelHandler)handler)).forEachOrdered(this.handlerInfos::add);
        return this.self;
    }

    public BUILDER add(String name, ChannelHandler ... newHandlers) {
        return this.add(name, Arrays.asList(newHandlers));
    }

    public BUILDER addGate(Predicate<Object> gatePredicate) {
        if (this.gatePredicate != null) {
            throw new IllegalStateException("Cannot have more than one gate.");
        }
        this.gatePredicate = gatePredicate;
        return this.self;
    }

    public BUILDER onClose(Runnable closeHandler) {
        if (this.closeHandler != null) {
            throw new IllegalStateException("Cannot have more than one close handler.");
        }
        this.closeHandler = closeHandler;
        return this.self;
    }

    public void install() {
        this.ensureErrorHandling();
        this.installGate();
        this.clearUserHandlers();
        String userHead = ERROR_HANDLER_HEAD;
        for (HandlerInfo info : this.handlerInfos) {
            this.pipeline.addAfter(userHead, info.name, info.handler);
            userHead = info.name;
        }
    }

    private void installGate() {
        if (this.pipeline.get(MESSAGE_GATE_NAME) != null && this.gatePredicate != null) {
            throw new IllegalStateException("Cannot have more than one gate.");
        }
        if (this.gatePredicate != null) {
            this.pipeline.addBefore(ERROR_HANDLER_TAIL, MESSAGE_GATE_NAME, (ChannelHandler)new MessageGate(this.gatePredicate));
        }
    }

    private void clearUserHandlers() {
        this.pipeline.names().stream().filter(this::isNotDefault).filter(this::isNotErrorHandler).filter(this::isNotGate).forEach(arg_0 -> ((ChannelPipeline)this.pipeline).remove(arg_0));
    }

    private boolean isNotDefault(String name) {
        return this.pipeline.get(name) != null;
    }

    private boolean isNotErrorHandler(String name) {
        return !name.equals(ERROR_HANDLER_HEAD) && !name.equals(ERROR_HANDLER_TAIL);
    }

    private boolean isNotGate(String name) {
        return !name.equals(MESSAGE_GATE_NAME);
    }

    private void ensureErrorHandling() {
        int size = this.pipeline.names().size();
        if (((String)this.pipeline.names().get(0)).equals(ERROR_HANDLER_HEAD)) {
            if (!((String)this.pipeline.names().get(size - 2)).equals(ERROR_HANDLER_TAIL)) {
                throw new IllegalStateException("Both error handlers must exist.");
            }
            return;
        }
        this.pipeline.addLast(ERROR_HANDLER_TAIL, (ChannelHandler)new ChannelDuplexHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                NettyPipelineBuilder.this.log.error(String.format("Exception in inbound for channel: %s", ctx.channel()), cause);
                ctx.close();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                NettyPipelineBuilder.this.log.error("Unhandled inbound message: %s for channel: %s", new Object[]{msg, ctx.channel()});
                ctx.close();
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (!promise.isVoid()) {
                    promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                        if (!future.isSuccess()) {
                            NettyPipelineBuilder.this.log.error(String.format("Exception in outbound for channel: %s", future.channel()), future.cause());
                            ctx.close();
                        }
                    }));
                }
                ctx.write(msg, promise);
            }

            public void channelInactive(ChannelHandlerContext ctx) {
                if (NettyPipelineBuilder.this.closeHandler != null) {
                    NettyPipelineBuilder.this.closeHandler.run();
                }
                ctx.fireChannelInactive();
            }
        });
        this.pipeline.addFirst(ERROR_HANDLER_HEAD, (ChannelHandler)new ChannelOutboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                NettyPipelineBuilder.this.log.error(String.format("Exception in outbound for channel: %s", ctx.channel()), cause);
                ctx.close();
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (!(msg instanceof ByteBuf)) {
                    NettyPipelineBuilder.this.log.error("Unhandled outbound message: %s for channel: %s", new Object[]{msg, ctx.channel()});
                    ctx.close();
                } else {
                    ctx.write(msg, promise);
                }
            }
        });
    }

    private static class HandlerInfo {
        private final String name;
        private final ChannelHandler handler;

        HandlerInfo(String name, ChannelHandler handler) {
            this.name = name;
            this.handler = handler;
        }
    }
}

