/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies;

import java.util.Objects;
import java.util.Set;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class ServerInfo {
    private final AdvertisedSocketAddress boltAddress;
    private MemberId memberId;
    private Set<String> groups;

    public ServerInfo(AdvertisedSocketAddress boltAddress, MemberId memberId, Set<String> groups) {
        this.boltAddress = boltAddress;
        this.memberId = memberId;
        this.groups = groups;
    }

    public MemberId memberId() {
        return this.memberId;
    }

    AdvertisedSocketAddress boltAddress() {
        return this.boltAddress;
    }

    Set<String> groups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfo that = (ServerInfo)o;
        return Objects.equals(this.boltAddress, that.boltAddress) && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(this.boltAddress, this.memberId, this.groups);
    }

    public String toString() {
        return "ServerInfo{boltAddress=" + this.boltAddress + ", memberId=" + this.memberId + ", groups=" + this.groups + '}';
    }
}

