/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;

public class ConnectRandomlyToServerGroupImpl {
    private final List<String> groups;
    private final TopologyService topologyService;
    private final MemberId myself;
    private final Random random = new Random();

    ConnectRandomlyToServerGroupImpl(List<String> groups, TopologyService topologyService, MemberId myself) {
        this.groups = groups;
        this.topologyService = topologyService;
        this.myself = myself;
    }

    public Optional<MemberId> upstreamDatabase() {
        Map<MemberId, ReadReplicaInfo> replicas = this.topologyService.localReadReplicas().members();
        List choices = this.groups.stream().flatMap(group -> replicas.entrySet().stream().filter(this.isMyGroupAndNotMe((String)group))).map(Map.Entry::getKey).collect(Collectors.toList());
        if (choices.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(choices.get(this.random.nextInt(choices.size())));
    }

    private Predicate<Map.Entry<MemberId, ReadReplicaInfo>> isMyGroupAndNotMe(String group) {
        return entry -> ((ReadReplicaInfo)entry.getValue()).groups().contains(group) && !((MemberId)entry.getKey()).equals(this.myself);
    }
}

