/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.Optional;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;

public class TypicallyConnectToRandomReadReplicaStrategy
extends UpstreamDatabaseSelectionStrategy {
    public static final String IDENTITY = "typically-connect-to-random-read-replica";
    private final ModuloCounter counter;

    public TypicallyConnectToRandomReadReplicaStrategy() {
        this(10);
    }

    public TypicallyConnectToRandomReadReplicaStrategy(int connectToCoreInterval) {
        super(IDENTITY, new String[0]);
        this.counter = new ModuloCounter(connectToCoreInterval);
    }

    @Override
    public Optional<MemberId> upstreamDatabase() {
        if (this.counter.shouldReturnCoreMemberId()) {
            return this.getCoreMemberId();
        }
        Optional<MemberId> memberId = this.getReadReplicaMemberId();
        if (!memberId.isPresent()) {
            memberId = this.getCoreMemberId();
        }
        return memberId;
    }

    private Optional<MemberId> getReadReplicaMemberId() {
        return this.topologyService.localReadReplicas().randomReadReplicaMemberId();
    }

    private Optional<MemberId> getCoreMemberId() {
        return this.topologyService.localCoreServers().randomCoreMemberId();
    }

    private static class ModuloCounter {
        private final int modulo;
        private int counter;

        ModuloCounter(int modulo) {
            this.modulo = modulo;
        }

        boolean shouldReturnCoreMemberId() {
            this.counter = (this.counter + 1) % this.modulo;
            return this.counter == 0;
        }
    }
}

