/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.DiscoveryServerInfo;
import org.neo4j.causalclustering.discovery.Topology;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.routing.load_balancing.filters.Filter;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.FilterConfigParser;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.InvalidFilterSpecification;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.ServerInfo;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;

public class UserDefinedConfigurationStrategy
extends UpstreamDatabaseSelectionStrategy {
    public static final String IDENTITY = "user-defined";
    private Optional<Filter<ServerInfo>> filters;

    public UserDefinedConfigurationStrategy() {
        super(IDENTITY, new String[0]);
    }

    @Override
    public void init() {
        String filterConfig = (String)this.config.get(CausalClusteringSettings.user_defined_upstream_selection_strategy);
        try {
            Filter<ServerInfo> parsed = FilterConfigParser.parse(filterConfig);
            this.filters = Optional.of(parsed);
            this.log.info("Upstream selection strategy " + this.readableName + " configured with " + filterConfig);
        }
        catch (InvalidFilterSpecification invalidFilterSpecification) {
            this.filters = Optional.empty();
            this.log.warn("Cannot parse configuration '" + filterConfig + "' for upstream selection strategy " + this.readableName + ". " + invalidFilterSpecification.getMessage());
        }
    }

    @Override
    public Optional<MemberId> upstreamDatabase() {
        return this.filters.flatMap(filters -> {
            Set<ServerInfo> possibleServers = this.possibleServers();
            return filters.apply(possibleServers).stream().map(ServerInfo::memberId).filter(memberId -> !Objects.equals(this.myself, memberId)).findFirst();
        });
    }

    private Set<ServerInfo> possibleServers() {
        Stream<ServerInfo> infoMap = Stream.of(this.topologyService.localReadReplicas(), this.topologyService.localCoreServers()).map(Topology::members).map(Map::entrySet).flatMap(Collection::stream);
        return infoMap.map(this::toServerInfo).collect(Collectors.toSet());
    }

    private <T extends DiscoveryServerInfo> ServerInfo toServerInfo(Map.Entry<MemberId, T> entry) {
        DiscoveryServerInfo server = (DiscoveryServerInfo)entry.getValue();
        MemberId memberId = entry.getKey();
        return new ServerInfo(server.connectors().boltAddress(), memberId, server.groups());
    }
}

