/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class KnownDataByteChannel
implements ReadableByteChannel {
    protected int position;
    private final int size;

    public KnownDataByteChannel(int size) {
        this.size = size;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int toRead = Math.min(dst.limit() - dst.position(), this.left());
        if (toRead == 0) {
            return -1;
        }
        for (int i = 0; i < toRead; ++i) {
            dst.put((byte)(this.position++ % 10));
        }
        return toRead;
    }

    private int left() {
        return this.size - this.position;
    }
}

