/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.com.storecopy.FileMoveAction;
import org.neo4j.com.storecopy.FileMoveActionInformer;
import org.neo4j.com.storecopy.FileMoveProvider;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;

public class FileMoveProviderTest {
    private DefaultFileSystemAbstraction defaultFileSystemAbstraction = new DefaultFileSystemAbstraction();
    private EphemeralFileSystemAbstraction ephemeralFileSystemAbstraction = new EphemeralFileSystemAbstraction();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.defaultFileSystemAbstraction);
    private FileMoveProvider subject;
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private PageCache pageCache;
    private FileMoveActionInformer fileMoveActionInformer;

    @Before
    public void setup() {
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.ephemeralFileSystemAbstraction);
        this.fileMoveActionInformer = (FileMoveActionInformer)Mockito.mock(FileMoveActionInformer.class);
        this.subject = new FileMoveProvider(this.pageCache, this.fileMoveActionInformer, (FileSystemAbstraction)this.defaultFileSystemAbstraction);
    }

    @Test
    public void moveSingleFiles() throws IOException {
        File sharedParent = this.testDirectory.cleanDirectory("shared_parent");
        File sourceParent = new File(sharedParent, "source");
        Assert.assertTrue((boolean)sourceParent.mkdirs());
        File sourceFile = new File(sourceParent, "file.txt");
        Assert.assertTrue((boolean)sourceFile.createNewFile());
        this.writeToFile(sourceFile, "Garbage data");
        File targetParent = new File(sharedParent, "target");
        Assert.assertTrue((boolean)targetParent.mkdirs());
        File targetFile = new File(targetParent, "file.txt");
        this.subject.traverseForMoving(sourceFile).forEach(this.moveToDirectory(targetParent));
        Assert.assertEquals((Object)"Garbage data", (Object)this.readFromFile(targetFile));
    }

    @Test
    public void singleDirectoriesAreNotMoved() throws IOException {
        File sharedParent = this.testDirectory.cleanDirectory("shared_parent");
        File sourceParent = new File(sharedParent, "source");
        Assert.assertTrue((boolean)sourceParent.mkdirs());
        File sourceDirectory = new File(sourceParent, "directory");
        Assert.assertTrue((boolean)sourceDirectory.mkdirs());
        File targetParent = new File(sharedParent, "target");
        Assert.assertTrue((boolean)targetParent.mkdirs());
        File targetDirectory = new File(targetParent, "directory");
        Assert.assertFalse((boolean)targetDirectory.exists());
        this.subject.traverseForMoving(sourceParent).forEach(this.moveToDirectory(targetDirectory));
        Assert.assertTrue((boolean)sourceDirectory.exists());
        Assert.assertFalse((boolean)targetDirectory.exists());
    }

    @Test
    public void moveNestedFiles() throws IOException {
        File sharedParent = this.testDirectory.cleanDirectory("shared_parent");
        File sourceParent = new File(sharedParent, "source");
        Assert.assertTrue((boolean)sourceParent.mkdirs());
        File targetParent = new File(sharedParent, "target");
        Assert.assertTrue((boolean)targetParent.mkdirs());
        File dirA = new File(sourceParent, "A");
        Assert.assertTrue((boolean)dirA.mkdirs());
        File nestedFileOne = new File(dirA, "file.txt");
        Assert.assertTrue((boolean)nestedFileOne.createNewFile());
        File dirB = new File(sourceParent, "B");
        Assert.assertTrue((boolean)dirB.mkdirs());
        File nestedFileTwo = new File(dirB, "file.txt");
        Assert.assertTrue((boolean)nestedFileTwo.createNewFile());
        this.writeToFile(nestedFileOne, "This is the file contained in directory A");
        this.writeToFile(nestedFileTwo, "This is the file contained in directory B");
        File targetFileOne = new File(targetParent, "A/file.txt");
        File targetFileTwo = new File(targetParent, "B/file.txt");
        this.subject.traverseForMoving(sourceParent).forEach(this.moveToDirectory(targetParent));
        Assert.assertEquals((Object)"This is the file contained in directory A", (Object)this.readFromFile(targetFileOne));
        Assert.assertEquals((Object)"This is the file contained in directory B", (Object)this.readFromFile(targetFileTwo));
    }

    @Test
    public void filesAreMovedViaPageCacheWhenNecessary() throws IOException {
        File parentDirectory = this.testDirectory.cleanDirectory("parent");
        File aNormalFile = new File(parentDirectory, "aNormalFile.A");
        Assert.assertTrue((boolean)aNormalFile.createNewFile());
        File targetDirectory = this.testDirectory.cleanDirectory("targetDirectory");
        this.pageCache.getCachedFileSystem().mkdirs(targetDirectory);
        File aPageCacheFile = new File(parentDirectory, "aBlockCopyFile.B");
        this.pageCache.getCachedFileSystem().mkdirs(parentDirectory);
        StoreChannel storeChannel = this.pageCache.getCachedFileSystem().create(aPageCacheFile);
        storeChannel.write(ByteBuffer.allocate(20).putChar('a').putChar('b'));
        Mockito.when((Object)this.fileMoveActionInformer.shouldBeManagedByPageCache((String)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.fileMoveActionInformer.shouldBeManagedByPageCache((String)ArgumentMatchers.eq((Object)aPageCacheFile.getName()))).thenReturn((Object)true);
        List<FileMoveAction> moveActions = this.subject.traverseForMoving(parentDirectory).collect(Collectors.toList());
        moveActions.forEach(this.moveToDirectory(targetDirectory));
        File expectedNormalCopy = new File(targetDirectory, aNormalFile.getName());
        Assert.assertTrue((boolean)expectedNormalCopy.exists());
        File expectedPageCacheCopy = new File(targetDirectory, aPageCacheFile.getName());
        Assert.assertTrue((String)expectedPageCacheCopy.toString(), (boolean)this.pageCache.getCachedFileSystem().fileExists(expectedPageCacheCopy));
    }

    @Test
    public void filesAreMovedBeforeDirectories() throws IOException {
        File parentDirectory = this.testDirectory.cleanDirectory("parent");
        File sourceDirectory = new File(parentDirectory, "source");
        Assert.assertTrue((boolean)sourceDirectory.mkdirs());
        File childFile = new File(sourceDirectory, "child");
        Assert.assertTrue((boolean)childFile.createNewFile());
        this.writeToFile(childFile, "Content");
        File targetDirectory = new File(parentDirectory, "target");
        Assert.assertTrue((boolean)targetDirectory.mkdirs());
        this.subject.traverseForMoving(sourceDirectory).forEach(this.moveToDirectory(targetDirectory));
    }

    private Consumer<FileMoveAction> moveToDirectory(File toDirectory) {
        return fileMoveAction -> {
            try {
                fileMoveAction.move(toDirectory, new CopyOption[0]);
            }
            catch (Throwable throwable) {
                throw new AssertionError((Object)throwable);
            }
        };
    }

    private String readFromFile(File input) throws IOException {
        int read;
        BufferedReader fileReader = new BufferedReader(new FileReader(input));
        StringBuilder stringBuilder = new StringBuilder();
        char[] data = new char[32];
        while ((read = fileReader.read(data)) != -1) {
            stringBuilder.append(data, 0, read);
        }
        return stringBuilder.toString();
    }

    private void writeToFile(File output, String input) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(output));){
            bw.write(input);
            bw.close();
        }
    }
}

