/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionObligationResponse;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class TransactionCommittingResponseUnpackerTest {
    @Rule
    public final LifeRule life = new LifeRule(true);

    @Test
    public void shouldUnfreezeKernelTransactionsAfterApplyIfBatchIsLarge() throws Throwable {
        int maxBatchSize = 10;
        long idReuseSafeZoneTime = 100L;
        TransactionCommittingResponseUnpacker.Dependencies dependencies = (TransactionCommittingResponseUnpacker.Dependencies)Mockito.mock(TransactionCommittingResponseUnpacker.Dependencies.class);
        TransactionObligationFulfiller fulfiller = (TransactionObligationFulfiller)Mockito.mock(TransactionObligationFulfiller.class);
        Mockito.when((Object)dependencies.obligationFulfiller()).thenReturn((Object)fulfiller);
        Mockito.when((Object)dependencies.logService()).thenReturn((Object)NullLogService.getInstance());
        Mockito.when((Object)dependencies.versionContextSupplier()).thenReturn((Object)EmptyVersionContextSupplier.EMPTY);
        KernelTransactions kernelTransactions = (KernelTransactions)Mockito.mock(KernelTransactions.class);
        Mockito.when((Object)dependencies.kernelTransactions()).thenReturn((Object)kernelTransactions);
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        Mockito.when((Object)dependencies.commitProcess()).thenReturn((Object)commitProcess);
        TransactionCommittingResponseUnpacker unpacker = (TransactionCommittingResponseUnpacker)this.life.add((Lifecycle)new TransactionCommittingResponseUnpacker(dependencies, maxBatchSize, idReuseSafeZoneTime));
        int txCount = maxBatchSize;
        int doesNotMatter = 1;
        unpacker.unpackResponse((Response)new DummyTransactionResponse(doesNotMatter, txCount, idReuseSafeZoneTime + 1L), ResponseUnpacker.TxHandler.NO_OP_TX_HANDLER);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{commitProcess, kernelTransactions});
        ((TransactionCommitProcess)inOrder.verify((Object)commitProcess, Mockito.times((int)1))).commit((TransactionToApply)ArgumentMatchers.any(), (CommitEvent)ArgumentMatchers.any(), (TransactionApplicationMode)ArgumentMatchers.any());
        ((KernelTransactions)inOrder.verify((Object)kernelTransactions, Mockito.times((int)1))).unblockNewTransactions();
    }

    @Test
    public void shouldAwaitTransactionObligationsToBeFulfilled() throws Throwable {
        TransactionCommittingResponseUnpacker.Dependencies dependencies = (TransactionCommittingResponseUnpacker.Dependencies)Mockito.mock(TransactionCommittingResponseUnpacker.Dependencies.class);
        TransactionObligationFulfiller fulfiller = (TransactionObligationFulfiller)Mockito.mock(TransactionObligationFulfiller.class);
        Mockito.when((Object)dependencies.obligationFulfiller()).thenReturn((Object)fulfiller);
        Mockito.when((Object)dependencies.logService()).thenReturn((Object)NullLogService.getInstance());
        TransactionCommittingResponseUnpacker unpacker = (TransactionCommittingResponseUnpacker)this.life.add((Lifecycle)new TransactionCommittingResponseUnpacker(dependencies, 10, 0L));
        unpacker.unpackResponse((Response)new DummyObligationResponse(4L), ResponseUnpacker.TxHandler.NO_OP_TX_HANDLER);
        ((TransactionObligationFulfiller)Mockito.verify((Object)fulfiller, (VerificationMode)Mockito.times((int)1))).fulfill(4L);
    }

    @Test
    public void shouldCommitTransactionsInBatches() throws Exception {
        TransactionCommittingResponseUnpacker.Dependencies dependencies = (TransactionCommittingResponseUnpacker.Dependencies)Mockito.mock(TransactionCommittingResponseUnpacker.Dependencies.class);
        TransactionCountingTransactionCommitProcess commitProcess = new TransactionCountingTransactionCommitProcess();
        Mockito.when((Object)dependencies.commitProcess()).thenReturn((Object)commitProcess);
        Mockito.when((Object)dependencies.logService()).thenReturn((Object)NullLogService.getInstance());
        Mockito.when((Object)dependencies.versionContextSupplier()).thenReturn((Object)EmptyVersionContextSupplier.EMPTY);
        KernelTransactions kernelTransactions = (KernelTransactions)Mockito.mock(KernelTransactions.class);
        Mockito.when((Object)dependencies.kernelTransactions()).thenReturn((Object)kernelTransactions);
        TransactionCommittingResponseUnpacker unpacker = (TransactionCommittingResponseUnpacker)this.life.add((Lifecycle)new TransactionCommittingResponseUnpacker(dependencies, 5, 0L));
        unpacker.unpackResponse((Response)new DummyTransactionResponse(2L, 7), ResponseUnpacker.TxHandler.NO_OP_TX_HANDLER);
        commitProcess.assertBatchSize(5);
        commitProcess.assertBatchSize(2);
        commitProcess.assertNoMoreBatches();
    }

    public class TransactionCountingTransactionCommitProcess
    implements TransactionCommitProcess {
        private final Queue<Integer> batchSizes = new LinkedList<Integer>();

        public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) {
            int batchSize = this.count(batch);
            this.batchSizes.offer(batchSize);
            return 42L;
        }

        protected void assertBatchSize(int expected) {
            int batchSize = this.batchSizes.poll();
            Assert.assertEquals((long)expected, (long)batchSize);
        }

        protected void assertNoMoreBatches() {
            Assert.assertTrue((boolean)this.batchSizes.isEmpty());
        }

        private int count(TransactionToApply batch) {
            int count = 0;
            while (batch != null) {
                ++count;
                batch = batch.next();
            }
            return count;
        }
    }

    private static class DummyTransactionResponse
    extends TransactionStreamResponse<Object> {
        private static final long UNDEFINED_BATCH_LENGTH = -1L;
        private final long startingAtTxId;
        private final int txCount;
        private final long batchLength;

        DummyTransactionResponse(long startingAtTxId, int txCount) {
            this(startingAtTxId, txCount, -1L);
        }

        DummyTransactionResponse(long startingAtTxId, int txCount, long batchLength) {
            super(new Object(), StoreId.DEFAULT, (TransactionStream)Mockito.mock(TransactionStream.class), ResourceReleaser.NO_OP);
            this.startingAtTxId = startingAtTxId;
            this.txCount = txCount;
            this.batchLength = batchLength;
        }

        private CommittedTransactionRepresentation tx(long id, long commitTimestamp) {
            PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(Collections.emptyList());
            representation.setHeader(new byte[0], 0, 0, commitTimestamp - 10L, id - 1L, commitTimestamp, 0);
            return new CommittedTransactionRepresentation(new LogEntryStart(0, 0, 0L, 0L, new byte[0], LogPosition.UNSPECIFIED), (TransactionRepresentation)representation, new LogEntryCommit(id, commitTimestamp));
        }

        private long timestamp(int txNbr, int txCount, long batchLength) {
            if (txCount == 1) {
                return 0L;
            }
            return (long)txNbr * batchLength / (long)(txCount - 1);
        }

        public void accept(Response.Handler handler) throws Exception {
            for (int i = 0; i < this.txCount; ++i) {
                handler.transactions().visit((Object)this.tx(this.startingAtTxId + (long)i, this.timestamp(i, this.txCount, this.batchLength)));
            }
        }
    }

    private static class DummyObligationResponse
    extends TransactionObligationResponse<Object> {
        DummyObligationResponse(long obligationTxId) {
            super(new Object(), StoreId.DEFAULT, obligationTxId, ResourceReleaser.NO_OP);
        }
    }
}

