/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;

public class StoreUtil {
    public static final String BRANCH_SUBDIRECTORY = "branched";
    private static final String[] DONT_MOVE_DIRECTORIES = new String[]{"metrics", "logs", "certificates"};
    public static final String TEMP_COPY_DIRECTORY_NAME = "temp-copy";
    private static final FileFilter STORE_FILE_FILTER = file -> {
        for (String directory : DONT_MOVE_DIRECTORIES) {
            if (!file.getName().equals(directory)) continue;
            return false;
        }
        return !StoreUtil.isBranchedDataRootDirectory(file) && !StoreUtil.isTemporaryCopy(file);
    };
    private static final FileFilter DEEP_STORE_FILE_FILTER = file -> {
        for (String directory : DONT_MOVE_DIRECTORIES) {
            if (!file.getPath().contains(directory)) continue;
            return false;
        }
        return !StoreUtil.isPartOfBranchedDataRootDirectory(file);
    };

    private StoreUtil() {
    }

    public static void cleanStoreDir(File storeDir, PageCache pageCache) throws IOException {
        for (File file : StoreUtil.relevantDbFiles(storeDir)) {
            FileUtils.deleteRecursively((File)file);
        }
        pageCache.getCachedFileSystem().streamFilesRecursive(storeDir).filter(fh -> DEEP_STORE_FILE_FILTER.accept(fh.getFile())).forEach(FileHandle.HANDLE_DELETE);
    }

    public static File newBranchedDataDir(File storeDir) {
        File result = StoreUtil.getBranchedDataDirectory(storeDir, System.currentTimeMillis());
        result.mkdirs();
        return result;
    }

    public static void moveAwayDb(File storeDir, File branchedDataDir, PageCache pageCache) throws IOException {
        for (File file : StoreUtil.relevantDbFiles(storeDir)) {
            FileUtils.moveFileToDirectory((File)file, (File)branchedDataDir);
        }
        StoreUtil.moveAwayDbWithPageCache(storeDir, branchedDataDir, pageCache, DEEP_STORE_FILE_FILTER);
    }

    public static void moveAwayDbWithPageCache(File from, File to, PageCache pageCache, FileFilter filter) {
        Stream fileHandleStream;
        try {
            fileHandleStream = pageCache.getCachedFileSystem().streamFilesRecursive(from);
        }
        catch (IOException e) {
            return;
        }
        Consumer handleRename = FileHandle.handleRenameBetweenDirectories((File)from, (File)to);
        fileHandleStream.filter(fh -> filter.accept(fh.getFile())).forEach(handleRename);
    }

    public static void deleteRecursive(File storeDir, PageCache pageCache) throws IOException {
        FileUtils.deleteRecursively((File)storeDir);
        pageCache.getCachedFileSystem().streamFilesRecursive(storeDir).forEach(FileHandle.HANDLE_DELETE);
    }

    public static boolean isBranchedDataDirectory(File file) {
        return file.isDirectory() && file.getParentFile().getName().equals(BRANCH_SUBDIRECTORY) && StringUtils.isNumeric((CharSequence)file.getName());
    }

    public static File getBranchedDataRootDirectory(File storeDir) {
        return new File(storeDir, BRANCH_SUBDIRECTORY);
    }

    public static File getBranchedDataDirectory(File storeDir, long timestamp) {
        return new File(StoreUtil.getBranchedDataRootDirectory(storeDir), "" + timestamp);
    }

    public static File[] relevantDbFiles(File storeDir) {
        if (!storeDir.exists()) {
            return new File[0];
        }
        return storeDir.listFiles(STORE_FILE_FILTER);
    }

    private static boolean isBranchedDataRootDirectory(File file) {
        return file.isDirectory() && BRANCH_SUBDIRECTORY.equals(file.getName());
    }

    private static boolean isTemporaryCopy(File file) {
        return file.isDirectory() && file.getName().equals(TEMP_COPY_DIRECTORY_NAME);
    }

    private static boolean isPartOfBranchedDataRootDirectory(File file) {
        return file.getPath().contains(BRANCH_SUBDIRECTORY);
    }
}

