/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.builtinprocs;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.storageengine.api.lock.ResourceType;

public class TransactionDependenciesResolver {
    private final Map<KernelTransactionHandle, List<QuerySnapshot>> handleSnapshotsMap;
    private Map<KernelTransactionHandle, Set<KernelTransactionHandle>> directDependencies;

    TransactionDependenciesResolver(Map<KernelTransactionHandle, List<QuerySnapshot>> handleSnapshotsMap) {
        this.handleSnapshotsMap = handleSnapshotsMap;
        this.directDependencies = this.initDirectDependencies();
    }

    public boolean isBlocked(KernelTransactionHandle handle) {
        return this.directDependencies.get(handle) != null;
    }

    public String describeBlockingTransactions(KernelTransactionHandle handle) {
        TreeSet<KernelTransactionHandle> allBlockers = new TreeSet<KernelTransactionHandle>(Comparator.comparingLong(KernelTransactionHandle::getUserTransactionId));
        Set<KernelTransactionHandle> handles = this.directDependencies.get(handle);
        if (handles != null) {
            ArrayDeque<KernelTransactionHandle> blockerQueue = new ArrayDeque<KernelTransactionHandle>(handles);
            while (!blockerQueue.isEmpty()) {
                Set<KernelTransactionHandle> transactionHandleSet;
                KernelTransactionHandle transactionHandle = (KernelTransactionHandle)blockerQueue.pop();
                if (!allBlockers.add(transactionHandle) || (transactionHandleSet = this.directDependencies.get(transactionHandle)) == null) continue;
                blockerQueue.addAll(transactionHandleSet);
            }
        }
        return this.describe(allBlockers);
    }

    public Map<String, Object> describeBlockingLocks(KernelTransactionHandle handle) {
        List<QuerySnapshot> querySnapshots = this.handleSnapshotsMap.get(handle);
        if (!querySnapshots.isEmpty()) {
            return querySnapshots.get(0).resourceInformation();
        }
        return Collections.emptyMap();
    }

    private Map<KernelTransactionHandle, Set<KernelTransactionHandle>> initDirectDependencies() {
        HashMap<KernelTransactionHandle, Set<KernelTransactionHandle>> directDependencies = new HashMap<KernelTransactionHandle, Set<KernelTransactionHandle>>();
        Map<KernelTransactionHandle, List<ActiveLock>> transactionLocksMap = this.handleSnapshotsMap.keySet().stream().collect(Collectors.toMap(Function.identity(), this.getTransactionLocks()));
        for (Map.Entry<KernelTransactionHandle, List<QuerySnapshot>> entry : this.handleSnapshotsMap.entrySet()) {
            List<QuerySnapshot> querySnapshots = entry.getValue();
            if (querySnapshots.isEmpty()) continue;
            KernelTransactionHandle txHandle = entry.getKey();
            this.evaluateDirectDependencies(directDependencies, transactionLocksMap, txHandle, querySnapshots.get(0));
        }
        return directDependencies;
    }

    private Function<KernelTransactionHandle, List<ActiveLock>> getTransactionLocks() {
        return transactionHandle -> transactionHandle.activeLocks().collect(Collectors.toList());
    }

    private void evaluateDirectDependencies(Map<KernelTransactionHandle, Set<KernelTransactionHandle>> directDependencies, Map<KernelTransactionHandle, List<ActiveLock>> handleLocksMap, KernelTransactionHandle txHandle, QuerySnapshot querySnapshot) {
        List waitingOnLocks = querySnapshot.waitingLocks();
        for (ActiveLock activeLock : waitingOnLocks) {
            for (Map.Entry<KernelTransactionHandle, List<ActiveLock>> handleListEntry : handleLocksMap.entrySet()) {
                KernelTransactionHandle kernelTransactionHandle = handleListEntry.getKey();
                if (kernelTransactionHandle.equals(txHandle) || !this.isBlocked(activeLock, handleListEntry.getValue())) continue;
                Set kernelTransactionHandles = directDependencies.computeIfAbsent(txHandle, handle -> new HashSet());
                kernelTransactionHandles.add(kernelTransactionHandle);
            }
        }
    }

    private boolean isBlocked(ActiveLock activeLock, List<ActiveLock> activeLocks) {
        return "EXCLUSIVE".equals(activeLock.mode()) ? TransactionDependenciesResolver.haveAnyLocking(activeLocks, activeLock.resourceType(), activeLock.resourceId()) : TransactionDependenciesResolver.haveExclusiveLocking(activeLocks, activeLock.resourceType(), activeLock.resourceId());
    }

    private static boolean haveAnyLocking(List<ActiveLock> locks, ResourceType resourceType, long resourceId) {
        return locks.stream().anyMatch(lock -> lock.resourceId() == resourceId && lock.resourceType() == resourceType);
    }

    private static boolean haveExclusiveLocking(List<ActiveLock> locks, ResourceType resourceType, long resourceId) {
        return locks.stream().anyMatch(lock -> "EXCLUSIVE".equals(lock.mode()) && lock.resourceId() == resourceId && lock.resourceType() == resourceType);
    }

    private String describe(Set<KernelTransactionHandle> allBlockers) {
        if (allBlockers.isEmpty()) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        for (KernelTransactionHandle blocker : allBlockers) {
            stringJoiner.add(blocker.getUserTransactionName());
        }
        return stringJoiner.toString();
    }
}

