/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.builtinprocs;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.enterprise.builtinprocs.ProceduresTimeFormatHelper;
import org.neo4j.kernel.enterprise.builtinprocs.QueryId;
import org.neo4j.kernel.enterprise.builtinprocs.TransactionDependenciesResolver;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

public class TransactionStatusResult {
    private static final String RUNNINS_STATE = "Running";
    private static final String TERMINATED_STATE = "Terminated with reason: %s";
    public final String transactionId;
    public final String username;
    public final Map<String, Object> metaData;
    public final String startTime;
    public final String protocol;
    public final String clientAddress;
    public final String requestUri;
    public final String currentQueryId;
    public final String currentQuery;
    public final long activeLockCount;
    public final String status;
    public Map<String, Object> resourceInformation;
    public final long elapsedTimeMillis;
    public final Long cpuTimeMillis;
    public final long waitTimeMillis;
    public final Long idleTimeMillis;
    public final Long allocatedBytes;
    public final Long allocatedDirectBytes;
    public final long pageHits;
    public final long pageFaults;

    public TransactionStatusResult(KernelTransactionHandle transaction, TransactionDependenciesResolver transactionDependenciesResolver, Map<KernelTransactionHandle, List<QuerySnapshot>> handleSnapshotsMap, ZoneId zoneId) throws InvalidArgumentsException {
        this.transactionId = transaction.getUserTransactionName();
        this.username = transaction.subject().username();
        this.startTime = ProceduresTimeFormatHelper.formatTime(transaction.startTime(), zoneId);
        Optional terminationReason = transaction.terminationReason();
        this.activeLockCount = transaction.activeLocks().count();
        List<QuerySnapshot> querySnapshots = handleSnapshotsMap.get(transaction);
        TransactionExecutionStatistic statistic = transaction.transactionStatistic();
        this.elapsedTimeMillis = statistic.getElapsedTimeMillis();
        this.cpuTimeMillis = statistic.getCpuTimeMillis();
        this.allocatedBytes = statistic.getHeapAllocatedBytes();
        this.allocatedDirectBytes = statistic.getDirectAllocatedBytes();
        this.waitTimeMillis = statistic.getWaitTimeMillis();
        this.idleTimeMillis = statistic.getIdleTimeMillis();
        this.pageHits = statistic.getPageHits();
        this.pageFaults = statistic.getPageFaults();
        if (!querySnapshots.isEmpty()) {
            QuerySnapshot snapshot = querySnapshots.get(0);
            ClientConnectionInfo clientConnectionInfo = snapshot.clientConnection();
            this.currentQueryId = QueryId.ofInternalId(snapshot.internalQueryId()).toString();
            this.currentQuery = snapshot.queryText();
            this.protocol = clientConnectionInfo.protocol();
            this.clientAddress = clientConnectionInfo.clientAddress();
            this.requestUri = clientConnectionInfo.requestURI();
        } else {
            this.currentQueryId = "";
            this.currentQuery = "";
            this.protocol = "";
            this.clientAddress = "";
            this.requestUri = "";
        }
        this.resourceInformation = transactionDependenciesResolver.describeBlockingLocks(transaction);
        this.status = this.getStatus(transaction, terminationReason, transactionDependenciesResolver);
        this.metaData = transaction.getMetaData();
    }

    private String getStatus(KernelTransactionHandle handle, Optional<Status> terminationReason, TransactionDependenciesResolver transactionDependenciesResolver) {
        return terminationReason.map(reason -> String.format(TERMINATED_STATE, reason.code())).orElseGet(() -> this.getExecutingStatus(handle, transactionDependenciesResolver));
    }

    private String getExecutingStatus(KernelTransactionHandle handle, TransactionDependenciesResolver transactionDependenciesResolver) {
        return transactionDependenciesResolver.isBlocked(handle) ? "Blocked by: " + transactionDependenciesResolver.describeBlockingTransactions(handle) : RUNNINS_STATE;
    }
}

