/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;

public class IndexPopulationFailedKernelExceptionTest {
    @Test
    public void shouldHandleMultiplePropertiesInConstructor1() {
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{42, 43, 44});
        TokenNameLookup lookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        Mockito.when((Object)lookup.labelGetName(0)).thenReturn((Object)"L");
        Mockito.when((Object)lookup.propertyKeyGetName(42)).thenReturn((Object)"FOO");
        Mockito.when((Object)lookup.propertyKeyGetName(43)).thenReturn((Object)"BAR");
        Mockito.when((Object)lookup.propertyKeyGetName(44)).thenReturn((Object)"BAZ");
        IndexPopulationFailedKernelException index = new IndexPopulationFailedKernelException((SchemaDescriptor)descriptor, "INDEX", (Throwable)new RuntimeException());
        MatcherAssert.assertThat((Object)index.getUserMessage(lookup), (Matcher)CoreMatchers.equalTo((Object)"Failed to populate index for INDEX [labelId: 0, properties [42, 43, 44]]"));
    }

    @Test
    public void shouldHandleMultiplePropertiesInConstructor2() {
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{42, 43, 44});
        TokenNameLookup lookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        Mockito.when((Object)lookup.labelGetName(0)).thenReturn((Object)"L");
        Mockito.when((Object)lookup.propertyKeyGetName(42)).thenReturn((Object)"FOO");
        Mockito.when((Object)lookup.propertyKeyGetName(43)).thenReturn((Object)"BAR");
        Mockito.when((Object)lookup.propertyKeyGetName(44)).thenReturn((Object)"BAZ");
        IndexPopulationFailedKernelException index = new IndexPopulationFailedKernelException((SchemaDescriptor)descriptor, "INDEX", "an act of pure evil occurred");
        MatcherAssert.assertThat((Object)index.getUserMessage(lookup), (Matcher)CoreMatchers.equalTo((Object)"Failed to populate index for INDEX [labelId: 0, properties [42, 43, 44]], due to an act of pure evil occurred"));
    }
}

