/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.ExecutingQueryList;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.StorageStatement;

public class KernelStatementTest {
    @Test
    public void shouldReleaseStorageStatementWhenForceClosed() {
        StorageStatement storeStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        KernelStatement statement = new KernelStatement((KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class), null, storeStatement, LockTracer.NONE, (StatementOperationParts)Mockito.mock(StatementOperationParts.class), new ClockContext(), EmptyVersionContextSupplier.EMPTY);
        statement.acquire();
        try {
            statement.forceClose();
        }
        catch (KernelStatement.StatementNotClosedException statementNotClosedException) {
            // empty catch block
        }
        ((StorageStatement)Mockito.verify((Object)storeStatement)).release();
    }

    @Test(expected=NotInTransactionException.class)
    public void assertStatementIsNotOpenWhileAcquireIsNotInvoked() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        TxStateHolder txStateHolder = (TxStateHolder)Mockito.mock(TxStateHolder.class);
        StorageStatement storeStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        KernelStatement statement = new KernelStatement(transaction, txStateHolder, storeStatement, LockTracer.NONE, (StatementOperationParts)Mockito.mock(StatementOperationParts.class), new ClockContext(), EmptyVersionContextSupplier.EMPTY);
        statement.assertOpen();
    }

    @Test
    public void reportQueryWaitingTimeToTransactionStatisticWhenFinishQueryExecution() {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        TxStateHolder txStateHolder = (TxStateHolder)Mockito.mock(TxStateHolder.class);
        StorageStatement storeStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        KernelTransactionImplementation.Statistics statistics = new KernelTransactionImplementation.Statistics(transaction, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new AtomicReference<HeapAllocation>(HeapAllocation.NOT_AVAILABLE));
        Mockito.when((Object)transaction.getStatistics()).thenReturn((Object)statistics);
        Mockito.when((Object)transaction.executingQueries()).thenReturn((Object)ExecutingQueryList.EMPTY);
        KernelStatement statement = new KernelStatement(transaction, txStateHolder, storeStatement, LockTracer.NONE, (StatementOperationParts)Mockito.mock(StatementOperationParts.class), new ClockContext(), EmptyVersionContextSupplier.EMPTY);
        statement.acquire();
        ExecutingQuery query = this.getQueryWithWaitingTime();
        ExecutingQuery query2 = this.getQueryWithWaitingTime();
        ExecutingQuery query3 = this.getQueryWithWaitingTime();
        statement.stopQueryExecution(query);
        statement.stopQueryExecution(query2);
        statement.stopQueryExecution(query3);
        Assert.assertEquals((long)3L, (long)statistics.getWaitingTimeNanos(1L));
    }

    private ExecutingQuery getQueryWithWaitingTime() {
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        Mockito.when((Object)executingQuery.reportedWaitingTimeNanos()).thenReturn((Object)1L);
        return executingQuery;
    }
}

