/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Iterator;
import org.junit.Assert;
import org.neo4j.kernel.impl.store.format.RecordKey;
import org.neo4j.kernel.impl.store.format.RecordKeys;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

class FullyCoveringRecordKeys
implements RecordKeys {
    public static final RecordKeys INSTANCE = new FullyCoveringRecordKeys();

    FullyCoveringRecordKeys() {
    }

    @Override
    public RecordKey<NodeRecord> node() {
        return (written, read) -> {
            Assert.assertEquals((long)written.getNextProp(), (long)read.getNextProp());
            Assert.assertEquals((long)written.getNextRel(), (long)read.getNextRel());
            Assert.assertEquals((long)written.getLabelField(), (long)read.getLabelField());
            Assert.assertEquals((Object)written.isDense(), (Object)read.isDense());
        };
    }

    @Override
    public RecordKey<RelationshipRecord> relationship() {
        return (written, read) -> {
            Assert.assertEquals((long)written.getNextProp(), (long)read.getNextProp());
            Assert.assertEquals((long)written.getFirstNode(), (long)read.getFirstNode());
            Assert.assertEquals((long)written.getSecondNode(), (long)read.getSecondNode());
            Assert.assertEquals((long)written.getType(), (long)read.getType());
            Assert.assertEquals((long)written.getFirstPrevRel(), (long)read.getFirstPrevRel());
            Assert.assertEquals((long)written.getFirstNextRel(), (long)read.getFirstNextRel());
            Assert.assertEquals((long)written.getSecondPrevRel(), (long)read.getSecondPrevRel());
            Assert.assertEquals((long)written.getSecondNextRel(), (long)read.getSecondNextRel());
            Assert.assertEquals((Object)written.isFirstInFirstChain(), (Object)read.isFirstInFirstChain());
            Assert.assertEquals((Object)written.isFirstInSecondChain(), (Object)read.isFirstInSecondChain());
        };
    }

    @Override
    public RecordKey<PropertyRecord> property() {
        return new RecordKey<PropertyRecord>(){

            @Override
            public void assertRecordsEquals(PropertyRecord written, PropertyRecord read) {
                Assert.assertEquals((long)written.getPrevProp(), (long)read.getPrevProp());
                Assert.assertEquals((long)written.getNextProp(), (long)read.getNextProp());
                Assert.assertEquals((Object)written.isNodeSet(), (Object)read.isNodeSet());
                if (written.isNodeSet()) {
                    Assert.assertEquals((long)written.getNodeId(), (long)read.getNodeId());
                } else {
                    Assert.assertEquals((long)written.getRelId(), (long)read.getRelId());
                }
                Assert.assertEquals((long)written.numberOfProperties(), (long)read.numberOfProperties());
                Iterator writtenBlocks = written.iterator();
                Iterator readBlocks = read.iterator();
                while (writtenBlocks.hasNext()) {
                    Assert.assertTrue((boolean)readBlocks.hasNext());
                    this.assertBlocksEquals((PropertyBlock)writtenBlocks.next(), (PropertyBlock)readBlocks.next());
                }
            }

            private void assertBlocksEquals(PropertyBlock written, PropertyBlock read) {
                Assert.assertEquals((long)written.getKeyIndexId(), (long)read.getKeyIndexId());
                Assert.assertEquals((long)written.getSize(), (long)read.getSize());
                Assert.assertTrue((boolean)written.hasSameContentsAs(read));
                Assert.assertArrayEquals((long[])written.getValueBlocks(), (long[])read.getValueBlocks());
            }
        };
    }

    @Override
    public RecordKey<RelationshipGroupRecord> relationshipGroup() {
        return (written, read) -> {
            Assert.assertEquals((long)written.getType(), (long)read.getType());
            Assert.assertEquals((long)written.getFirstOut(), (long)read.getFirstOut());
            Assert.assertEquals((long)written.getFirstIn(), (long)read.getFirstIn());
            Assert.assertEquals((long)written.getFirstLoop(), (long)read.getFirstLoop());
            Assert.assertEquals((long)written.getNext(), (long)read.getNext());
            Assert.assertEquals((long)written.getOwningNode(), (long)read.getOwningNode());
        };
    }

    @Override
    public RecordKey<RelationshipTypeTokenRecord> relationshipTypeToken() {
        return (written, read) -> Assert.assertEquals((long)written.getNameId(), (long)read.getNameId());
    }

    @Override
    public RecordKey<PropertyKeyTokenRecord> propertyKeyToken() {
        return (written, read) -> {
            Assert.assertEquals((long)written.getNameId(), (long)read.getNameId());
            Assert.assertEquals((long)written.getPropertyCount(), (long)read.getPropertyCount());
        };
    }

    @Override
    public RecordKey<LabelTokenRecord> labelToken() {
        return (written, read) -> Assert.assertEquals((long)written.getNameId(), (long)read.getNameId());
    }

    @Override
    public RecordKey<DynamicRecord> dynamic() {
        return (written, read) -> {
            Assert.assertEquals((long)written.getLength(), (long)read.getLength());
            Assert.assertEquals((long)written.getNextBlock(), (long)read.getNextBlock());
            Assert.assertArrayEquals((byte[])written.getData(), (byte[])read.getData());
            Assert.assertEquals((Object)written.isStartRecord(), (Object)read.isStartRecord());
        };
    }
}

