/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;

public class LogPositionMarkerTest {
    @Test
    public void shouldReturnUnspecifiedIfNothingHasBeenMarked() {
        LogPositionMarker marker = new LogPositionMarker();
        LogPosition logPosition = marker.newPosition();
        Assert.assertEquals((Object)LogPosition.UNSPECIFIED, (Object)logPosition);
    }

    @Test
    public void shouldReturnTheMarkedPosition() {
        LogPositionMarker marker = new LogPositionMarker();
        marker.mark(1L, 2L);
        LogPosition logPosition = marker.newPosition();
        Assert.assertEquals((Object)new LogPosition(1L, 2L), (Object)logPosition);
    }

    @Test
    public void shouldReturnUnspecifiedWhenAskedTo() {
        LogPositionMarker marker = new LogPositionMarker();
        marker.mark(1L, 2L);
        marker.unspecified();
        LogPosition logPosition = marker.newPosition();
        Assert.assertEquals((Object)LogPosition.UNSPECIFIED, (Object)logPosition);
    }
}

