/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.IOException;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.NullLogProvider;

public class DatabaseHealthTest {
    @Test
    public void shouldGenerateDatabasePanicEvents() {
        DatabasePanicEventGenerator generator = (DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class);
        DatabaseHealth databaseHealth = new DatabaseHealth(generator, NullLogProvider.getInstance().getLog(DatabaseHealth.class));
        databaseHealth.healed();
        Exception cause = new Exception("My own fault");
        databaseHealth.panic((Throwable)cause);
        databaseHealth.panic((Throwable)cause);
        ((DatabasePanicEventGenerator)Mockito.verify((Object)generator, (VerificationMode)Mockito.times((int)1))).generateEvent(ErrorState.TX_MANAGER_NOT_OK, (Throwable)cause);
    }

    @Test
    public void shouldLogDatabasePanicEvent() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), logProvider.getLog(DatabaseHealth.class));
        databaseHealth.healed();
        String message = "Listen everybody... panic!";
        Exception exception = new Exception(message);
        databaseHealth.panic((Throwable)exception);
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(DatabaseHealth.class).error(Is.is((Object)"Database panic: The database has encountered a critical error, and needs to be restarted. Please see database logs for more details."), Matchers.sameInstance((Object)exception))});
    }

    @Test
    public void healDatabaseWithoutCriticalErrors() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), logProvider.getLog(DatabaseHealth.class));
        Assert.assertTrue((boolean)databaseHealth.isHealthy());
        databaseHealth.panic((Throwable)new IOException("Space exception."));
        Assert.assertFalse((boolean)databaseHealth.isHealthy());
        Assert.assertTrue((boolean)databaseHealth.healed());
        logProvider.assertContainsLogCallContaining("Database health set to OK");
        logProvider.assertNoMessagesContaining("Database encountered a critical error and can't be healed. Restart required.");
    }

    @Test
    public void databaseWithCriticalErrorsCanNotBeHealed() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseHealth databaseHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), logProvider.getLog(DatabaseHealth.class));
        Assert.assertTrue((boolean)databaseHealth.isHealthy());
        IOException criticalException = new IOException("Space exception.", new OutOfMemoryError("Out of memory."));
        databaseHealth.panic((Throwable)criticalException);
        Assert.assertFalse((boolean)databaseHealth.isHealthy());
        Assert.assertFalse((boolean)databaseHealth.healed());
        logProvider.assertNoMessagesContaining("Database health set to OK");
        logProvider.assertContainsLogCallContaining("Database encountered a critical error and can't be healed. Restart required.");
    }
}

