/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RecordIdIterator;

public class RecordIdIteratorTest {
    @Test
    public void shouldGoPageWiseBackwards() {
        RecordIdIterator ids = RecordIdIterator.backwards((long)0L, (long)33L, (Configuration)Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)10));
        this.assertIds(ids, RecordIdIteratorTest.array(30L, 31L, 32L), RecordIdIteratorTest.array(20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L), RecordIdIteratorTest.array(10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L), RecordIdIteratorTest.array(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L));
    }

    @Test
    public void shouldGoPageWiseBackwardsOnCleanBreak() {
        RecordIdIterator ids = RecordIdIterator.backwards((long)0L, (long)20L, (Configuration)Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)10));
        this.assertIds(ids, RecordIdIteratorTest.array(10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L), RecordIdIteratorTest.array(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L));
    }

    @Test
    public void shouldGoPageWiseBackwardsOnSingleBatch() {
        RecordIdIterator ids = RecordIdIterator.backwards((long)0L, (long)8L, (Configuration)Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)10));
        this.assertIds(ids, new long[][]{RecordIdIteratorTest.array(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L)});
    }

    @Test
    public void shouldGoBackwardsToNonZero() {
        RecordIdIterator ids = RecordIdIterator.backwards((long)12L, (long)34L, (Configuration)Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)10));
        this.assertIds(ids, RecordIdIteratorTest.array(30L, 31L, 32L, 33L), RecordIdIteratorTest.array(20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L), RecordIdIteratorTest.array(12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L));
    }

    @Test
    public void shouldGoForwardsWhenStartingFromNonZero() {
        RecordIdIterator ids = RecordIdIterator.forwards((long)1L, (long)12L, (Configuration)Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)10));
        this.assertIds(ids, RecordIdIteratorTest.array(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L), RecordIdIteratorTest.array(10L, 11L));
    }

    @Test
    public void shouldGoForwardsWhenStartingFromNonZero2() {
        RecordIdIterator ids = RecordIdIterator.forwards((long)34L, (long)66L, (Configuration)Configuration.withBatchSize((Configuration)Configuration.DEFAULT, (int)10));
        this.assertIds(ids, RecordIdIteratorTest.array(34L, 35L, 36L, 37L, 38L, 39L), RecordIdIteratorTest.array(40L, 41L, 42L, 43L, 44L, 45L, 46L, 47L, 48L, 49L), RecordIdIteratorTest.array(50L, 51L, 52L, 53L, 54L, 55L, 56L, 57L, 58L, 59L), RecordIdIteratorTest.array(60L, 61L, 62L, 63L, 64L, 65L));
    }

    private void assertIds(RecordIdIterator ids, long[] ... expectedIds) {
        for (long[] expectedArray : expectedIds) {
            PrimitiveLongIterator iterator = ids.nextBatch();
            Assert.assertNotNull((Object)iterator);
            for (long expectedId : expectedArray) {
                Assert.assertEquals((long)expectedId, (long)iterator.next());
            }
            Assert.assertFalse((boolean)iterator.hasNext());
        }
        Assert.assertNull((Object)ids.nextBatch());
    }

    private static long[] array(long ... ids) {
        return ids;
    }
}

