/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheLongArray;

public class PageCacheLongArrayTest {
    private static final int COUNT = 1000000;
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory dir = TestDirectory.testDirectory();
    private final RandomRule random = new RandomRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.dir).around((TestRule)this.random).around((TestRule)this.pageCacheRule);

    @Test
    public void verifyPageCacheLongArray() throws Exception {
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
        PagedFile file = pageCache.map(this.dir.file("file"), pageCache.pageSize(), new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE});
        try (PageCacheLongArray array = new PageCacheLongArray(file, 1000000L, 0L, 0L);){
            this.verifyBehaviour((LongArray)array);
        }
    }

    @Test
    public void verifyChunkingArrayWithPageCacheLongArray() {
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
        File directory = this.dir.directory();
        NumberArrayFactory numberArrayFactory = NumberArrayFactory.auto((PageCache)pageCache, (File)directory, (boolean)false);
        try (LongArray array = numberArrayFactory.newDynamicLongArray(1000L, 0L);){
            this.verifyBehaviour(array);
        }
    }

    private void verifyBehaviour(LongArray array) {
        int i;
        for (i = 0; i < 1000000; ++i) {
            array.set((long)i, (long)i);
        }
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((long)i, (long)array.get((long)i));
        }
        int stride = 12345678;
        int next = this.random.nextInt(1000000);
        for (int i2 = 0; i2 < 1000000; ++i2) {
            Assert.assertEquals((long)next, (long)array.get((long)next));
            next = (next + stride) % 1000000;
        }
    }
}

