/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Factory;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.test.Race;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.BigIdTracker;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.CollisionValues;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.ControlledEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.IntTracker;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongCollisionValues;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringCollisionValues;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.TrackerFactory;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;

@RunWith(value=Parameterized.class)
public class EncodingIdMapperTest {
    private final int processors;
    private final Groups groups = new Groups();
    private static final TrackerFactory RANDOM_TRACKER_FACTORY = (arrayFactory, size) -> System.currentTimeMillis() % 2L == 0L ? new IntTracker(arrayFactory.newIntArray(size, -1)) : new BigIdTracker(arrayFactory.newByteArray(size, BigIdTracker.DEFAULT_VALUE));
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final RepeatRule repeater = new RepeatRule();

    @Parameterized.Parameters(name="processors:{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{1});
        data.add(new Object[]{2});
        int bySystem = Runtime.getRuntime().availableProcessors() - 1;
        if (bySystem > 2) {
            data.add(new Object[]{bySystem});
        }
        return data;
    }

    public EncodingIdMapperTest(int processors) {
        this.processors = processors;
    }

    @Test
    public void shouldHandleGreatAmountsOfStuff() {
        long nodeId;
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        LongFunction<Object> inputIdLookup = String::valueOf;
        int count = 300000;
        for (nodeId = 0L; nodeId < (long)count; ++nodeId) {
            idMapper.put(inputIdLookup.apply(nodeId), nodeId, Group.GLOBAL);
        }
        idMapper.prepare(inputIdLookup, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (nodeId = 0L; nodeId < (long)count; ++nodeId) {
            Object id = inputIdLookup.apply(nodeId);
            if (idMapper.get(id, Group.GLOBAL) != -1L) continue;
            Assert.fail((String)("Couldn't find " + id + " even though I added it just previously"));
        }
    }

    @Test
    public void shouldReturnExpectedValueForNotFound() {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        idMapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        long id = idMapper.get((Object)"123", Group.GLOBAL);
        Assert.assertEquals((long)-1L, (long)id);
    }

    @Test
    public void shouldReportyProgressForSortAndDetect() {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        ProgressListener progress = (ProgressListener)Mockito.mock(ProgressListener.class);
        idMapper.prepare(null, (Collector)Mockito.mock(Collector.class), progress);
        long id = idMapper.get((Object)"123", Group.GLOBAL);
        Assert.assertEquals((long)-1L, (long)id);
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)3))).started(ArgumentMatchers.anyString());
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)3))).done();
    }

    @Test
    public void shouldEncodeShortStrings() {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        mapper.put((Object)"123", 0L, Group.GLOBAL);
        mapper.put((Object)"456", 1L, Group.GLOBAL);
        mapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"456", Group.GLOBAL));
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"123", Group.GLOBAL));
    }

    @Test
    public void shouldEncodeSmallSetOfRandomData() {
        int nodeId;
        int size = this.random.nextInt(10000) + 2;
        ValueType type = ValueType.values()[this.random.nextInt(ValueType.values().length)];
        IdMapper mapper = this.mapper(type.encoder(), type.radix(), EncodingIdMapper.NO_MONITOR);
        ValueGenerator values = new ValueGenerator(type.data(this.random.random()));
        for (nodeId = 0; nodeId < size; ++nodeId) {
            mapper.put(values.apply(nodeId), (long)nodeId, Group.GLOBAL);
        }
        mapper.prepare((LongFunction)values, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (nodeId = 0; nodeId < size; ++nodeId) {
            Object value = values.values.get(nodeId);
            Assert.assertEquals((String)("Expected " + value + " to map to " + nodeId), (long)nodeId, (long)mapper.get(value, Group.GLOBAL));
        }
    }

    @Test
    public void shouldReportCollisionsForSameInputId() {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        LongFunction<Object> values = this.values("10", "9", "10");
        for (int i = 0; i < 3; ++i) {
            mapper.put(values.apply(i), (long)i, Group.GLOBAL);
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(values, collector, ProgressListener.NONE);
        ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectDuplicateNode((Object)"10", 2L, Group.GLOBAL.name());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
    }

    private static LongFunction<Object> wrap(List<Object> ids) {
        return nodeId -> ids.get(Math.toIntExact(nodeId));
    }

    @Test
    public void shouldCopeWithCollisionsBasedOnDifferentInputIds() {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        Encoder encoder = (Encoder)Mockito.mock(Encoder.class);
        Mockito.when((Object)encoder.encode(ArgumentMatchers.any())).thenReturn((Object)12345L);
        IdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.STRING, monitor);
        LongFunction<Object> ids = this.values("10", "9");
        for (int i = 0; i < 2; ++i) {
            mapper.put(ids.apply(i), (long)i, Group.GLOBAL);
        }
        ProgressListener progress = (ProgressListener)Mockito.mock(ProgressListener.class);
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, progress);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(2L);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"10", Group.GLOBAL));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"9", Group.GLOBAL));
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)7))).started(ArgumentMatchers.anyString());
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)7))).done();
    }

    @Test
    public void shouldCopeWithMixedActualAndAccidentalCollisions() {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        Encoder encoder = (Encoder)Mockito.mock(Encoder.class);
        String a = new String("a");
        String b = new String("b");
        String c = new String("c");
        String a2 = new String("a");
        String e = new String("e");
        String f = new String("f");
        Mockito.when((Object)encoder.encode((Object)a)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)b)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)c)).thenReturn((Object)3L);
        Mockito.when((Object)encoder.encode((Object)a2)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)e)).thenReturn((Object)2L);
        Mockito.when((Object)encoder.encode((Object)f)).thenReturn((Object)1L);
        Group groupA = this.groups.getOrCreate("A");
        Group groupB = this.groups.getOrCreate("B");
        IdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.STRING, monitor);
        LongFunction<Object> ids = this.values("a", "b", "c", "a", "e", "f");
        Group[] groups = new Group[]{groupA, groupA, groupA, groupB, groupB, groupB};
        for (int i = 0; i < 6; ++i) {
            mapper.put(ids.apply(i), (long)i, groups[i]);
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, (ProgressListener)Mockito.mock(ProgressListener.class));
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(4L);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)a, groupA));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)b, groupA));
        Assert.assertEquals((long)2L, (long)mapper.get((Object)c, groupA));
        Assert.assertEquals((long)3L, (long)mapper.get((Object)a2, groupB));
        Assert.assertEquals((long)4L, (long)mapper.get((Object)e, groupB));
        Assert.assertEquals((long)5L, (long)mapper.get((Object)f, groupB));
    }

    @Test
    public void shouldBeAbleToHaveDuplicateInputIdButInDifferentGroups() {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        Group firstGroup = this.groups.getOrCreate("first");
        Group secondGroup = this.groups.getOrCreate("second");
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, monitor);
        LongFunction<Object> ids = this.values("10", "9", "10");
        int id = 0;
        mapper.put(ids.apply(id), (long)id++, firstGroup);
        mapper.put(ids.apply(id), (long)id++, firstGroup);
        mapper.put(ids.apply(id), (long)id++, secondGroup);
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, ProgressListener.NONE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(0L);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"10", firstGroup));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"9", firstGroup));
        Assert.assertEquals((long)2L, (long)mapper.get((Object)"10", secondGroup));
        Assert.assertFalse((boolean)mapper.leftOverDuplicateNodesIds().hasNext());
    }

    @Test
    public void shouldOnlyFindInputIdsInSpecificGroup() {
        Group firstGroup = this.groups.getOrCreate("first");
        Group secondGroup = this.groups.getOrCreate("second");
        Group thirdGroup = this.groups.getOrCreate("third");
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        LongFunction<Object> ids = this.values("8", "9", "10");
        int id = 0;
        mapper.put(ids.apply(id), (long)id++, firstGroup);
        mapper.put(ids.apply(id), (long)id++, secondGroup);
        mapper.put(ids.apply(id), (long)id++, thirdGroup);
        mapper.prepare(ids, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"8", firstGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"8", secondGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"8", thirdGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"9", firstGroup));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"9", secondGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"9", thirdGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"10", firstGroup));
        Assert.assertEquals((long)-1L, (long)mapper.get((Object)"10", secondGroup));
        Assert.assertEquals((long)2L, (long)mapper.get((Object)"10", thirdGroup));
    }

    @Test
    public void shouldHandleManyGroups() {
        int i;
        int size = 256;
        for (int i2 = 0; i2 < size; ++i2) {
            this.groups.getOrCreate("" + i2);
        }
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR);
        for (i = 0; i < size; ++i) {
            mapper.put((Object)i, (long)i, this.groups.get("" + i));
        }
        mapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)i, (long)mapper.get((Object)i, this.groups.get("" + i)));
        }
    }

    @Test
    public void shouldDetectCorrectDuplicateInputIdsWhereManyAccidentalInManyGroups() {
        ControlledEncoder encoder = new ControlledEncoder((Encoder)new LongEncoder());
        int idsPerGroup = 20;
        int groupCount = 5;
        for (int i = 0; i < groupCount; ++i) {
            this.groups.getOrCreate("Group " + i);
        }
        IdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR, ParallelSort.DEFAULT, numberOfCollisions -> new LongCollisionValues(NumberArrayFactory.HEAP, numberOfCollisions));
        AtomicReference group = new AtomicReference();
        LongFunction<Object> ids = nodeId -> {
            int groupId = Math.toIntExact(nodeId / 20L);
            if (groupId == groupCount) {
                return null;
            }
            group.set(this.groups.get(groupId));
            if (nodeId % 20L < 2L) {
                encoder.useThisIdToEncodeNoMatterWhatComesIn(1234567L);
                return nodeId % 20L;
            }
            encoder.useThisIdToEncodeNoMatterWhatComesIn(123456 - ((Group)group.get()).id());
            return nodeId;
        };
        int count = 20 * groupCount;
        for (long nodeId2 = 0L; nodeId2 < (long)count; ++nodeId2) {
            mapper.put(ids.apply(nodeId2), nodeId2, (Group)group.get());
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, ProgressListener.NONE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        for (long nodeId3 = 0L; nodeId3 < (long)count; ++nodeId3) {
            Assert.assertEquals((long)nodeId3, (long)mapper.get(ids.apply(nodeId3), (Group)group.get()));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        Assert.assertFalse((boolean)mapper.leftOverDuplicateNodesIds().hasNext());
    }

    @Test
    public void shouldHandleHolesInIdSequence() {
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < 100; ++i) {
            if (this.random.nextBoolean()) continue;
            Long id = i;
            ids.add(id);
            mapper.put((Object)id, (long)i, Group.GLOBAL);
        }
        mapper.prepare(this.values(ids.toArray()), (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (Long id : ids) {
            Assert.assertEquals((long)id, (long)mapper.get((Object)id, Group.GLOBAL));
        }
    }

    @Test
    public void shouldHandleLargeAmountsOfDuplicateNodeIds() {
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR);
        long nodeId = 0L;
        int high = 10;
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int run = 0; run < 2; ++run) {
            for (long i = 0L; i < (long)(high / 2); ++i) {
                ids.add((long)high - (i + 1L));
                ids.add(i);
            }
        }
        for (Object e : ids) {
            mapper.put(e, nodeId++, Group.GLOBAL);
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(this.values(ids.toArray()), collector, ProgressListener.NONE);
        ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)high))).collectDuplicateNode(ArgumentMatchers.any(Object.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString());
        Assert.assertEquals((long)high, (long)PrimitiveLongCollections.count((PrimitiveLongIterator)mapper.leftOverDuplicateNodesIds()));
    }

    @Test
    public void shouldDetectLargeAmountsOfCollisions() {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        int count = 20000;
        ArrayList<String> ids = new ArrayList<String>();
        long id = 0L;
        for (int elements = 0; elements < count; ++elements) {
            String inputId = UUID.randomUUID().toString();
            for (int i = 0; i < 2; ++i) {
                ids.add(inputId);
                mapper.put((Object)inputId, id++, Group.GLOBAL);
            }
        }
        CountingCollector collector = new CountingCollector();
        mapper.prepare(this.values(ids.toArray()), (Collector)collector, ProgressListener.NONE);
        Assert.assertEquals((long)count, (long)collector.count);
    }

    @Test
    public void shouldPutFromMultipleThreads() throws Throwable {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR);
        AtomicLong highNodeId = new AtomicLong();
        int batchSize = 1234;
        Race race = new Race();
        LongFunction<Object> inputIdLookup = String::valueOf;
        int countPerThread = 30000;
        race.addContestants(this.processors, () -> {
            int cursor = batchSize;
            long nextNodeId = 0L;
            for (int j = 0; j < countPerThread; ++j) {
                long nodeId;
                if (cursor == batchSize) {
                    nextNodeId = highNodeId.getAndAdd(batchSize);
                    cursor = 0;
                }
                ++nextNodeId;
                ++cursor;
                idMapper.put(inputIdLookup.apply(nodeId), nodeId, Group.GLOBAL);
            }
        });
        race.go();
        idMapper.prepare(inputIdLookup, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        int count = this.processors * countPerThread;
        int countWithGapsWorstCase = count + batchSize * this.processors;
        int correctHits = 0;
        for (long nodeId = 0L; nodeId < (long)countWithGapsWorstCase; ++nodeId) {
            long result = idMapper.get(inputIdLookup.apply(nodeId), Group.GLOBAL);
            if (result == -1L) continue;
            Assert.assertEquals((long)nodeId, (long)result);
            ++correctHits;
        }
        Assert.assertEquals((long)count, (long)correctHits);
    }

    private LongFunction<Object> values(Object ... values) {
        return value -> values[Math.toIntExact(value)];
    }

    private IdMapper mapper(Encoder encoder, Factory<Radix> radix, EncodingIdMapper.Monitor monitor) {
        return this.mapper(encoder, radix, monitor, ParallelSort.DEFAULT);
    }

    private IdMapper mapper(Encoder encoder, Factory<Radix> radix, EncodingIdMapper.Monitor monitor, ParallelSort.Comparator comparator) {
        return this.mapper(encoder, radix, monitor, comparator, this.autoDetect(encoder));
    }

    private IdMapper mapper(Encoder encoder, Factory<Radix> radix, EncodingIdMapper.Monitor monitor, ParallelSort.Comparator comparator, LongFunction<CollisionValues> collisionValuesFactory) {
        return new EncodingIdMapper(NumberArrayFactory.HEAP, encoder, radix, monitor, RANDOM_TRACKER_FACTORY, this.groups, collisionValuesFactory, 1000, this.processors, comparator);
    }

    private LongFunction<CollisionValues> autoDetect(Encoder encoder) {
        return numberOfCollisions -> encoder instanceof LongEncoder ? new LongCollisionValues(NumberArrayFactory.HEAP, numberOfCollisions) : new StringCollisionValues(NumberArrayFactory.HEAP, numberOfCollisions);
    }

    private static class CountingCollector
    implements Collector {
        private int count;

        private CountingCollector() {
        }

        public void collectBadRelationship(Object startId, String startIdGroup, String type, Object endId, String endIdGroup, Object specificValue) {
            throw new UnsupportedOperationException();
        }

        public void collectDuplicateNode(Object id, long actualId, String group) {
            ++this.count;
        }

        public boolean isCollectingBadRelationships() {
            return false;
        }

        public void collectExtraColumns(String source, long row, String value) {
            throw new UnsupportedOperationException();
        }

        public long badEntries() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }

    private static enum ValueType {
        LONGS{

            @Override
            Encoder encoder() {
                return new LongEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.LONG;
            }

            @Override
            Factory<Object> data(Random random) {
                return () -> random.nextInt(1000000000);
            }
        }
        ,
        LONGS_AS_STRINGS{

            @Override
            Encoder encoder() {
                return new StringEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.STRING;
            }

            @Override
            Factory<Object> data(Random random) {
                return () -> String.valueOf(random.nextInt(1000000000));
            }
        }
        ,
        VERY_LONG_STRINGS{
            char[] CHARS = "\u00bd!\"#\u00a4%&/()=?`\u00b4;:,._-<>".toCharArray();

            @Override
            Encoder encoder() {
                return new StringEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.STRING;
            }

            @Override
            Factory<Object> data(final Random random) {
                return new Factory<Object>(){

                    public Object newInstance() {
                        int length = 1500;
                        for (int i = 0; i < 4; ++i) {
                            length = random.nextInt(length) + 20;
                        }
                        char[] chars = new char[length];
                        for (int i = 0; i < length; ++i) {
                            char ch = random.nextBoolean() ? this.randomLetter(random) : CHARS[random.nextInt(CHARS.length)];
                            chars[i] = ch;
                        }
                        return new String(chars);
                    }

                    private char randomLetter(Random random2) {
                        int base = random2.nextBoolean() ? 97 : 65;
                        int size = 25;
                        return (char)(base + random2.nextInt(size));
                    }
                };
            }
        };


        abstract Encoder encoder();

        abstract Factory<Radix> radix();

        abstract Factory<Object> data(Random var1);
    }

    private class ValueGenerator
    implements LongFunction<Object> {
        private final Factory<Object> generator;
        private final List<Object> values = new ArrayList<Object>();
        private final Set<Object> deduper = new HashSet<Object>();

        ValueGenerator(Factory<Object> generator) {
            this.generator = generator;
        }

        @Override
        public Object apply(long nodeId) {
            Object value;
            while (!this.deduper.add(value = this.generator.newInstance())) {
            }
            this.values.add(value);
            return value;
        }
    }
}

