/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.IntTracker;

public class IntTrackerTest {
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldKeepIdsAndMarkDuplicates() {
        int length = 10000;
        try (IntTracker tracker = new IntTracker(NumberArrayFactory.HEAP.newIntArray((long)length, -1));){
            int i;
            long[] values = new long[length];
            boolean[] marks = new boolean[length];
            for (i = 0; i < length; ++i) {
                values[i] = this.random.nextLong(Integer.MAX_VALUE);
                tracker.set((long)i, values[i]);
                if (!this.random.nextBoolean()) continue;
                tracker.markAsDuplicate((long)i);
                marks[i] = true;
            }
            for (i = 0; i < length; ++i) {
                Assert.assertEquals((long)values[i], (long)tracker.get((long)i));
                Assert.assertEquals((Object)marks[i], (Object)tracker.isMarkedAsDuplicate((long)i));
            }
        }
    }
}

