/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongCollisionValues;

@RunWith(value=Parameterized.class)
public class LongCollisionValuesTest {
    @Rule
    public final RandomRule random = new RandomRule();
    @Parameterized.Parameter(value=0)
    public NumberArrayFactory factory;

    @Parameterized.Parameters
    public static Collection<NumberArrayFactory> data() {
        return Arrays.asList(NumberArrayFactory.HEAP, NumberArrayFactory.OFF_HEAP, NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, NumberArrayFactory.CHUNKED_FIXED_SIZE);
    }

    @Test
    public void shouldStoreAndLoadLongs() {
        try (LongCollisionValues values = new LongCollisionValues(this.factory, 100L);){
            int i;
            long[] offsets = new long[100];
            long[] longs = new long[offsets.length];
            for (i = 0; i < offsets.length; ++i) {
                long value = this.random.nextLong(Long.MAX_VALUE);
                offsets[i] = values.add((Object)value);
                longs[i] = value;
            }
            for (i = 0; i < offsets.length; ++i) {
                Assert.assertEquals((long)longs[i], (long)((Long)values.get(offsets[i])));
            }
        }
    }
}

