/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.util.Map;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.ForcedSecondaryUnitRecordFormats;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.values.storable.Values;

public class BatchingNeoStoresTest {
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();

    @Test
    public void shouldNotOpenStoreWithNodesOrRelationshipsInIt() throws Exception {
        this.someDataInTheDatabase();
        try {
            RecordFormats recordFormats = RecordFormatSelector.selectForConfig((Config)Config.defaults(), (LogProvider)NullLogProvider.getInstance());
            try (BatchingNeoStores store = BatchingNeoStores.batchingNeoStores((FileSystemAbstraction)this.storage.fileSystem(), (File)this.storage.directory().absolutePath(), (RecordFormats)recordFormats, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());){
                store.createNew();
                Assert.fail((String)"Should fail on existing data");
            }
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"already contains"));
        }
    }

    @Test
    public void shouldRespectDbConfig() throws Exception {
        int size = 10;
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.array_block_size.name(), String.valueOf(size), GraphDatabaseSettings.string_block_size.name(), String.valueOf(size)}));
        RecordFormats recordFormats = Standard.LATEST_RECORD_FORMATS;
        int headerSize = recordFormats.dynamic().getRecordHeaderSize();
        try (BatchingNeoStores store = BatchingNeoStores.batchingNeoStores((FileSystemAbstraction)this.storage.fileSystem(), (File)this.storage.directory().absolutePath(), (RecordFormats)recordFormats, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)config);){
            store.createNew();
            Assert.assertEquals((long)(size + headerSize), (long)store.getPropertyStore().getArrayStore().getRecordSize());
            Assert.assertEquals((long)(size + headerSize), (long)store.getPropertyStore().getStringStore().getRecordSize());
        }
    }

    @Test
    public void shouldPruneAndOpenExistingDatabase() throws Exception {
        for (StoreType typeToTest : this.relevantRecordStores()) {
            try (PageCache pageCache = this.storage.pageCache();){
                this.storage.directory().cleanup();
                try (BatchingNeoStores stores = BatchingNeoStores.batchingNeoStoresWithExternalPageCache((FileSystemAbstraction)this.storage.fileSystem(), (PageCache)pageCache, (PageCacheTracer)PageCacheTracer.NULL, (File)this.storage.directory().absolutePath(), (RecordFormats)Standard.LATEST_RECORD_FORMATS, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());){
                    stores.createNew();
                    for (StoreType type2 : this.relevantRecordStores()) {
                        this.createRecordIn(stores.getNeoStores().getRecordStore(type2));
                    }
                }
                stores = BatchingNeoStores.batchingNeoStoresWithExternalPageCache((FileSystemAbstraction)this.storage.fileSystem(), (PageCache)pageCache, (PageCacheTracer)PageCacheTracer.NULL, (File)this.storage.directory().absolutePath(), (RecordFormats)Standard.LATEST_RECORD_FORMATS, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());
                var8_10 = null;
                try {
                    stores.pruneAndOpenExistingStore(type -> type == typeToTest, Predicates.alwaysFalse());
                    for (StoreType type2 : this.relevantRecordStores()) {
                        RecordStore store = stores.getNeoStores().getRecordStore(type2);
                        if (type2 == typeToTest) {
                            Assert.assertThat((String)store.toString(), (Object)((int)store.getHighId()), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(store.getNumberOfReservedLowIds())));
                            continue;
                        }
                        Assert.assertEquals((String)store.toString(), (long)store.getNumberOfReservedLowIds(), (long)store.getHighId());
                    }
                }
                catch (Throwable throwable) {
                    var8_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (stores != null) {
                        if (var8_10 != null) {
                            try {
                                stores.close();
                            }
                            catch (Throwable throwable) {
                                var8_10.addSuppressed(throwable);
                            }
                        } else {
                            stores.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void shouldDecideToAllocateDoubleRelationshipRecordUnitsOnLargeAmountOfRelationshipsOnSupportedFormat() throws Exception {
        ForcedSecondaryUnitRecordFormats formats = new ForcedSecondaryUnitRecordFormats(Standard.LATEST_RECORD_FORMATS);
        try (PageCache pageCache = this.storage.pageCache();
             BatchingNeoStores stores = BatchingNeoStores.batchingNeoStoresWithExternalPageCache((FileSystemAbstraction)this.storage.fileSystem(), (PageCache)pageCache, (PageCacheTracer)PageCacheTracer.NULL, (File)this.storage.directory().absolutePath(), (RecordFormats)formats, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());){
            stores.createNew();
            Input.Estimates estimates = Inputs.knownEstimates((long)0L, (long)0x400000000L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);
            boolean doubleUnits = stores.determineDoubleRelationshipRecordUnits(estimates);
            Assert.assertTrue((boolean)doubleUnits);
        }
    }

    @Test
    public void shouldNotDecideToAllocateDoubleRelationshipRecordUnitsonLowAmountOfRelationshipsOnSupportedFormat() throws Exception {
        ForcedSecondaryUnitRecordFormats formats = new ForcedSecondaryUnitRecordFormats(Standard.LATEST_RECORD_FORMATS);
        try (BatchingNeoStores stores = BatchingNeoStores.batchingNeoStoresWithExternalPageCache((FileSystemAbstraction)this.storage.fileSystem(), (PageCache)this.storage.pageCache(), (PageCacheTracer)PageCacheTracer.NULL, (File)this.storage.directory().absolutePath(), (RecordFormats)formats, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());){
            stores.createNew();
            Input.Estimates estimates = Inputs.knownEstimates((long)0L, (long)0x100000000L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);
            boolean doubleUnits = stores.determineDoubleRelationshipRecordUnits(estimates);
            Assert.assertFalse((boolean)doubleUnits);
        }
    }

    @Test
    public void shouldNotDecideToAllocateDoubleRelationshipRecordUnitsonLargeAmountOfRelationshipsOnUnsupportedFormat() throws Exception {
        RecordFormats formats = Standard.LATEST_RECORD_FORMATS;
        try (BatchingNeoStores stores = BatchingNeoStores.batchingNeoStoresWithExternalPageCache((FileSystemAbstraction)this.storage.fileSystem(), (PageCache)this.storage.pageCache(), (PageCacheTracer)PageCacheTracer.NULL, (File)this.storage.directory().absolutePath(), (RecordFormats)formats, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());){
            stores.createNew();
            Input.Estimates estimates = Inputs.knownEstimates((long)0L, (long)0x400000000L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);
            boolean doubleUnits = stores.determineDoubleRelationshipRecordUnits(estimates);
            Assert.assertFalse((boolean)doubleUnits);
        }
    }

    private StoreType[] relevantRecordStores() {
        return (StoreType[])Stream.of(StoreType.values()).filter(type -> type.isRecordStore() && type != StoreType.META_DATA).toArray(StoreType[]::new);
    }

    private <RECORD extends AbstractBaseRecord> void createRecordIn(RecordStore<RECORD> store) {
        AbstractBaseRecord record = store.newRecord();
        record.setId(store.nextId());
        record.setInUse(true);
        if (record instanceof PropertyRecord) {
            PropertyBlock block = new PropertyBlock();
            ((PropertyStore)store).encodeValue(block, 0, Values.of((Object)10));
            ((PropertyRecord)record).addPropertyBlock(block);
        }
        store.updateRecord(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void someDataInTheDatabase() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.storage.fileSystem())).newImpermanentDatabase(this.storage.directory().absolutePath());
        try (Transaction tx = db.beginTx();){
            db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }
}

