/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.index.schema.NativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

class FilteringNativeHitIndexProgressor<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
extends NativeHitIndexProgressor<KEY, VALUE> {
    private final IndexQuery[] filter;

    FilteringNativeHitIndexProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose, IndexQuery[] filter) {
        super(seeker, client, toRemoveFromOnClose);
        this.filter = filter;
    }

    @Override
    protected boolean acceptValue(Value[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (this.filter[i].acceptsValue(values[i])) continue;
            return false;
        }
        return true;
    }
}

