/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.diagnostics;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.neo4j.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReportSources;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.metrics.MetricsSettings;

public class MetricsDiagnosticsOfflineReportProvider
extends DiagnosticsOfflineReportProvider {
    private FileSystemAbstraction fs;
    private Config config;

    public MetricsDiagnosticsOfflineReportProvider() {
        super("metrics", "metrics", new String[0]);
    }

    public void init(FileSystemAbstraction fs, Config config, File storeDirectory) {
        this.fs = fs;
        this.config = config;
    }

    protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
        File metricsDirectory = (File)this.config.get(MetricsSettings.csvPath);
        if (this.fs.fileExists(metricsDirectory) && this.fs.isDirectory(metricsDirectory)) {
            ArrayList<DiagnosticsReportSource> files = new ArrayList<DiagnosticsReportSource>();
            for (File file : this.fs.listFiles(metricsDirectory)) {
                files.add(DiagnosticsReportSources.newDiagnosticsFile((String)("metrics/" + file.getName()), (FileSystemAbstraction)this.fs, (File)file));
            }
            return files;
        }
        return Collections.emptyList();
    }
}

