/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.HTTPServer;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.metrics.output.EventReporter;

public class PrometheusOutput
implements Lifecycle,
EventReporter {
    private final HostnamePort hostnamePort;
    private final MetricRegistry registry;
    private final Log logger;
    private HTTPServer server;
    private Map<String, Object> registeredEvents = new ConcurrentHashMap<String, Object>();
    private final MetricRegistry eventRegistry;

    public PrometheusOutput(HostnamePort hostnamePort, MetricRegistry registry, Log logger) {
        this.hostnamePort = hostnamePort;
        this.registry = registry;
        this.logger = logger;
        this.eventRegistry = new MetricRegistry();
    }

    public void init() {
        CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(this.registry));
        CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(this.eventRegistry));
    }

    public void start() throws Throwable {
        if (this.server == null) {
            this.server = new HTTPServer(this.hostnamePort.getHost(), this.hostnamePort.getPort(), true);
            this.logger.info("Started publishing Prometheus metrics at http://" + this.hostnamePort + "/metrics");
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
            this.logger.info("Stopped Prometheus endpoint at http://" + this.hostnamePort + "/metrics");
        }
    }

    public void shutdown() {
        this.stop();
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        String metricKey = gauges.firstKey();
        if (!this.registeredEvents.containsKey(metricKey)) {
            this.eventRegistry.register(metricKey, (Metric)((Gauge)() -> this.registeredEvents.get(metricKey)));
        }
        this.registeredEvents.put(metricKey, ((Gauge)gauges.get(metricKey)).getValue());
    }
}

