/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source;

import com.codahale.metrics.MetricRegistry;
import java.util.function.Supplier;
import org.neo4j.causalclustering.core.consensus.CoreMetaData;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.api.LogRotationMonitor;
import org.neo4j.kernel.impl.factory.Edition;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerMonitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.output.EventReporter;
import org.neo4j.metrics.source.causalclustering.CatchUpMetrics;
import org.neo4j.metrics.source.causalclustering.CoreMetrics;
import org.neo4j.metrics.source.causalclustering.ReadReplicaMetrics;
import org.neo4j.metrics.source.cluster.ClusterMetrics;
import org.neo4j.metrics.source.cluster.NetworkMetrics;
import org.neo4j.metrics.source.db.BoltMetrics;
import org.neo4j.metrics.source.db.CheckPointingMetrics;
import org.neo4j.metrics.source.db.CypherMetrics;
import org.neo4j.metrics.source.db.EntityCountMetrics;
import org.neo4j.metrics.source.db.LogRotationMetrics;
import org.neo4j.metrics.source.db.PageCacheMetrics;
import org.neo4j.metrics.source.db.TransactionMetrics;
import org.neo4j.metrics.source.jvm.GCMetrics;
import org.neo4j.metrics.source.jvm.MemoryBuffersMetrics;
import org.neo4j.metrics.source.jvm.MemoryPoolMetrics;
import org.neo4j.metrics.source.jvm.ThreadMetrics;
import org.neo4j.metrics.source.server.ServerMetrics;

public class Neo4jMetricsBuilder {
    private final MetricRegistry registry;
    private final LifeSupport life;
    private final EventReporter reporter;
    private final Config config;
    private final LogService logService;
    private final KernelContext kernelContext;
    private final Dependencies dependencies;

    public Neo4jMetricsBuilder(MetricRegistry registry, EventReporter reporter, Config config, LogService logService, KernelContext kernelContext, Dependencies dependencies, LifeSupport life) {
        this.registry = registry;
        this.reporter = reporter;
        this.config = config;
        this.logService = logService;
        this.kernelContext = kernelContext;
        this.dependencies = dependencies;
        this.life = life;
    }

    public boolean build() {
        boolean result = false;
        if (((Boolean)this.config.get(MetricsSettings.neoTxEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new TransactionMetrics(this.registry, this.dependencies.transactionIdStore(), this.dependencies.transactionCounters()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.neoPageCacheEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new PageCacheMetrics(this.registry, this.dependencies.pageCacheCounters()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.neoCheckPointingEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new CheckPointingMetrics(this.reporter, this.registry, this.dependencies.monitors(), this.dependencies.checkPointerMonitor()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.neoLogRotationEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new LogRotationMetrics(this.reporter, this.registry, this.dependencies.monitors(), this.dependencies.logRotationMonitor()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.neoCountsEnabled)).booleanValue() && this.kernelContext.databaseInfo().edition != Edition.community && this.kernelContext.databaseInfo().edition != Edition.unknown) {
            this.life.add((Lifecycle)new EntityCountMetrics(this.registry, this.dependencies.entityCountStats()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.neoNetworkEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new NetworkMetrics(this.registry, this.dependencies.monitors()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.neoClusterEnabled)).booleanValue() && this.kernelContext.databaseInfo().operationalMode == OperationalMode.ha) {
            this.life.add((Lifecycle)new ClusterMetrics(this.dependencies.monitors(), this.registry, this.dependencies.clusterMembers()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.cypherPlanningEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new CypherMetrics(this.registry, this.dependencies.monitors()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.jvmGcEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new GCMetrics(this.registry));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.jvmThreadsEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new ThreadMetrics(this.registry));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.boltMessagesEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new BoltMetrics(this.registry, this.dependencies.monitors()));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.jvmMemoryEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new MemoryPoolMetrics(this.registry));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.jvmBuffersEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new MemoryBuffersMetrics(this.registry));
            result = true;
        }
        if (((Boolean)this.config.get(MetricsSettings.causalClusteringEnabled)).booleanValue()) {
            OperationalMode mode = this.kernelContext.databaseInfo().operationalMode;
            if (mode == OperationalMode.core) {
                this.life.add((Lifecycle)new CoreMetrics(this.dependencies.monitors(), this.registry, this.dependencies.raft()));
                this.life.add((Lifecycle)new CatchUpMetrics(this.dependencies.monitors(), this.registry));
                result = true;
            } else if (mode == OperationalMode.read_replica) {
                this.life.add((Lifecycle)new ReadReplicaMetrics(this.dependencies.monitors(), this.registry));
                this.life.add((Lifecycle)new CatchUpMetrics(this.dependencies.monitors(), this.registry));
                result = true;
            }
        }
        if (((Boolean)this.config.get(MetricsSettings.neoServerEnabled)).booleanValue()) {
            this.life.add((Lifecycle)new ServerMetrics(this.registry, this.logService, this.kernelContext.dependencySatisfier()));
            result = true;
        }
        return result;
    }

    public static interface Dependencies {
        public Monitors monitors();

        public TransactionCounters transactionCounters();

        public PageCacheCounters pageCacheCounters();

        public CheckPointerMonitor checkPointerMonitor();

        public LogRotationMonitor logRotationMonitor();

        public StoreEntityCounters entityCountStats();

        public Supplier<ClusterMembers> clusterMembers();

        public Supplier<CoreMetaData> raft();

        public Supplier<TransactionIdStore> transactionIdStore();
    }
}

