/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Collections;
import java.util.TreeMap;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.api.DefaultTransactionTracer;
import org.neo4j.kernel.impl.api.LogRotationMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.output.EventReporter;

@Documented(value=".Database LogRotation Metrics")
public class LogRotationMetrics
extends LifecycleAdapter {
    private static final String LOG_ROTATION_PREFIX = "neo4j.log_rotation";
    @Documented(value="The total number of transaction log rotations executed so far")
    public static final String LOG_ROTATION_EVENTS = MetricRegistry.name((String)"neo4j.log_rotation", (String[])new String[]{"events"});
    @Documented(value="The total time spent in rotating transaction logs so far")
    public static final String LOG_ROTATION_TOTAL_TIME = MetricRegistry.name((String)"neo4j.log_rotation", (String[])new String[]{"total_time"});
    @Documented(value="The duration of the log rotation event")
    public static final String LOG_ROTATION_DURATION = MetricRegistry.name((String)"neo4j.log_rotation", (String[])new String[]{"log_rotation_duration"});
    private final MetricRegistry registry;
    private final Monitors monitors;
    private final LogRotationMonitor logRotationMonitor;
    private final DefaultTransactionTracer.Monitor listener;

    public LogRotationMetrics(EventReporter reporter, MetricRegistry registry, Monitors monitors, LogRotationMonitor logRotationMonitor) {
        this.registry = registry;
        this.monitors = monitors;
        this.logRotationMonitor = logRotationMonitor;
        this.listener = durationMillis -> {
            TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
            gauges.put(LOG_ROTATION_DURATION, () -> durationMillis);
            reporter.report(gauges, Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptySortedMap());
        };
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.listener, new String[0]);
        this.registry.register(LOG_ROTATION_EVENTS, (Metric)((Gauge)() -> ((LogRotationMonitor)this.logRotationMonitor).numberOfLogRotationEvents()));
        this.registry.register(LOG_ROTATION_TOTAL_TIME, (Metric)((Gauge)() -> ((LogRotationMonitor)this.logRotationMonitor).logRotationAccumulatedTotalTimeMillis()));
    }

    public void stop() {
        this.monitors.removeMonitorListener((Object)this.listener);
        this.registry.remove(LOG_ROTATION_EVENTS);
        this.registry.remove(LOG_ROTATION_TOTAL_TIME);
    }
}

