/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.server;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.metrics.source.server.ServerThreadView;

@Documented(value=".Server Metrics")
public class ServerMetrics
extends LifecycleAdapter {
    private static final String NAME_PREFIX = "neo4j.server";
    @Documented(value="The total number of idle threads in the jetty pool")
    public static final String THREAD_JETTY_IDLE = MetricRegistry.name((String)"neo4j.server", (String[])new String[]{"threads.jetty.idle"});
    @Documented(value="The total number of threads (both idle and busy) in the jetty pool")
    public static final String THREAD_JETTY_ALL = MetricRegistry.name((String)"neo4j.server", (String[])new String[]{"threads.jetty.all"});
    private final MetricRegistry registry;
    private volatile ServerThreadView serverThreadView;

    public ServerMetrics(MetricRegistry registry, LogService logService, DependencySatisfier satisfier) {
        final Log userLog = logService.getUserLog(((Object)((Object)this)).getClass());
        this.registry = registry;
        this.serverThreadView = new ServerThreadView(){
            private volatile boolean warnedAboutIdle;
            private volatile boolean warnedAboutAll;

            @Override
            public int idleThreads() {
                if (!this.warnedAboutIdle) {
                    userLog.warn("Server thread metrics not available (missing " + THREAD_JETTY_IDLE + ")");
                    this.warnedAboutIdle = true;
                }
                return -1;
            }

            @Override
            public int allThreads() {
                if (!this.warnedAboutAll) {
                    userLog.warn("Server thread metrics not available (missing " + THREAD_JETTY_ALL + ")");
                    this.warnedAboutAll = true;
                }
                return -1;
            }
        };
        satisfier.satisfyDependency(serverThreadView -> {
            assert (this.serverThreadView != null);
            this.serverThreadView = serverThreadView;
            userLog.info("Server thread metrics has been registered successfully");
        });
    }

    public void start() {
        this.registry.register(THREAD_JETTY_IDLE, (Metric)((Gauge)() -> this.serverThreadView.idleThreads()));
        this.registry.register(THREAD_JETTY_ALL, (Metric)((Gauge)() -> this.serverThreadView.allThreads()));
    }

    public void stop() {
        this.registry.remove(THREAD_JETTY_IDLE);
        this.registry.remove(THREAD_JETTY_ALL);
    }
}

