/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.bolt.ManagedBoltStateMachine;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class AuthProceduresBase {
    @Context
    public EnterpriseSecurityContext securityContext;
    @Context
    public GraphDatabaseAPI graph;
    @Context
    public SecurityLog securityLog;
    @Context
    public EnterpriseUserManager userManager;

    protected void kickoutUser(String username, String reason) {
        try {
            this.terminateTransactionsForValidUser(username);
            this.terminateConnectionsForValidUser(username);
        }
        catch (Exception e) {
            this.securityLog.error(this.securityContext.subject(), "failed to terminate running transaction and bolt connections for user `%s` following %s: %s", username, reason, e.getMessage());
            throw e;
        }
    }

    protected void terminateTransactionsForValidUser(String username) {
        KernelTransaction currentTx = this.getCurrentTx();
        this.getActiveTransactions().stream().filter(tx -> tx.subject().hasUsername(username) && !tx.isUnderlyingTransaction(currentTx)).forEach(tx -> tx.markForTermination((Status)Status.Transaction.Terminated));
    }

    protected void terminateConnectionsForValidUser(String username) {
        this.getBoltConnectionTracker().getActiveConnections(username).forEach(ManagedBoltStateMachine::terminate);
    }

    private Set<KernelTransactionHandle> getActiveTransactions() {
        return ((KernelTransactions)this.graph.getDependencyResolver().resolveDependency(KernelTransactions.class)).activeTransactions();
    }

    private BoltConnectionTracker getBoltConnectionTracker() {
        return (BoltConnectionTracker)this.graph.getDependencyResolver().resolveDependency(BoltConnectionTracker.class);
    }

    private KernelTransaction getCurrentTx() {
        return ((ThreadToStatementContextBridge)this.graph.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }

    protected UserResult userResultForSubject() {
        String username = this.securityContext.subject().username();
        User user = this.userManager.silentlyGetUser(username);
        List<String> flags = user == null ? Collections.emptyList() : user.getFlags();
        return new UserResult(username, this.securityContext.roles(), flags);
    }

    protected UserResult userResultForName(String username) {
        if (username.equals(this.securityContext.subject().username())) {
            return this.userResultForSubject();
        }
        User user = this.userManager.silentlyGetUser(username);
        List<String> flags = user == null ? Collections.emptyList() : user.getFlags();
        Set<String> roles = this.userManager.silentlyGetRoleNamesForUser(username);
        return new UserResult(username, roles, flags);
    }

    protected RoleResult roleResultForName(String roleName) {
        return new RoleResult(roleName, this.userManager.silentlyGetUsernamesForRole(roleName));
    }

    public static class RoleResult {
        public final String role;
        public final List<String> users;

        RoleResult(String role, Set<String> users) {
            this.role = role;
            this.users = new ArrayList<String>();
            this.users.addAll(users);
        }
    }

    public static class UserResult {
        public final String username;
        public final List<String> roles;
        public final List<String> flags;

        UserResult(String username, Set<String> roles, Iterable<String> flags) {
            this.username = username;
            this.roles = new ArrayList<String>();
            this.roles.addAll(roles);
            this.flags = new ArrayList<String>();
            for (String f : flags) {
                this.flags.add(f);
            }
        }
    }

    public static class StringResult {
        public final String value;

        StringResult(String value) {
            this.value = value;
        }
    }
}

