/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.PredefinedRolesBuilder;
import org.neo4j.server.security.enterprise.auth.RealmLifecycle;
import org.neo4j.server.security.enterprise.auth.RoleRecord;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;
import org.neo4j.server.security.enterprise.auth.ShiroAuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.ShiroAuthorizationInfoProvider;

public class InternalFlatFileRealm
extends AuthorizingRealm
implements RealmLifecycle,
EnterpriseUserManager,
ShiroAuthorizationInfoProvider {
    static final String IS_SUSPENDED = "is_suspended";
    private static int MAX_READ_ATTEMPTS = 10;
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private final UserRepository initialUserRepository;
    private final UserRepository defaultAdminRepository;
    private final PasswordPolicy passwordPolicy;
    private final AuthenticationStrategy authenticationStrategy;
    private final boolean authenticationEnabled;
    private final boolean authorizationEnabled;
    private final JobScheduler jobScheduler;
    private volatile JobScheduler.JobHandle reloadJobHandle;

    public InternalFlatFileRealm(UserRepository userRepository, RoleRepository roleRepository, PasswordPolicy passwordPolicy, AuthenticationStrategy authenticationStrategy, JobScheduler jobScheduler, UserRepository initialUserRepository, UserRepository defaultAdminRepository) {
        this(userRepository, roleRepository, passwordPolicy, authenticationStrategy, true, true, jobScheduler, initialUserRepository, defaultAdminRepository);
    }

    InternalFlatFileRealm(UserRepository userRepository, RoleRepository roleRepository, PasswordPolicy passwordPolicy, AuthenticationStrategy authenticationStrategy, boolean authenticationEnabled, boolean authorizationEnabled, JobScheduler jobScheduler, UserRepository initialUserRepository, UserRepository defaultAdminRepository) {
        this.setName("native");
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.initialUserRepository = initialUserRepository;
        this.defaultAdminRepository = defaultAdminRepository;
        this.passwordPolicy = passwordPolicy;
        this.authenticationStrategy = authenticationStrategy;
        this.authenticationEnabled = authenticationEnabled;
        this.authorizationEnabled = authorizationEnabled;
        this.jobScheduler = jobScheduler;
        this.setAuthenticationCachingEnabled(false);
        this.setAuthorizationCachingEnabled(false);
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
        this.setRolePermissionResolver(PredefinedRolesBuilder.rolePermissionResolver);
    }

    @Override
    public void initialize() throws Throwable {
        this.initialUserRepository.init();
        this.defaultAdminRepository.init();
        this.userRepository.init();
        this.roleRepository.init();
    }

    @Override
    public void start() throws Throwable {
        this.initialUserRepository.start();
        this.defaultAdminRepository.start();
        this.userRepository.start();
        this.roleRepository.start();
        Set<String> addedDefaultUsers = this.ensureDefaultUsers();
        this.ensureDefaultRoles(addedDefaultUsers);
        this.scheduleNextFileReload();
    }

    protected void scheduleNextFileReload() {
        this.reloadJobHandle = this.jobScheduler.schedule(JobScheduler.Groups.nativeSecurity, this::readFilesFromDisk, 10L, TimeUnit.SECONDS);
    }

    private void readFilesFromDisk() {
        try {
            this.readFilesFromDisk(MAX_READ_ATTEMPTS, new LinkedList<String>());
        }
        finally {
            this.scheduleNextFileReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFilesFromDisk(int attemptLeft, List<String> failures) {
        if (attemptLeft < 0) {
            throw new RuntimeException("Unable to load valid flat file repositories! Attempts failed with:\n\t" + String.join((CharSequence)"\n\t", failures));
        }
        try {
            boolean valid;
            boolean needsUpdate;
            InternalFlatFileRealm internalFlatFileRealm = this;
            synchronized (internalFlatFileRealm) {
                ListSnapshot users = this.userRepository.getPersistedSnapshot();
                ListSnapshot<RoleRecord> roles = this.roleRepository.getPersistedSnapshot();
                needsUpdate = users.fromPersisted() || roles.fromPersisted();
                boolean bl = valid = needsUpdate && RoleRepository.validate(users.values(), roles.values());
                if (valid) {
                    if (users.fromPersisted()) {
                        this.userRepository.setUsers(users);
                    }
                    if (roles.fromPersisted()) {
                        this.roleRepository.setRoles(roles);
                    }
                }
            }
            if (needsUpdate && !valid) {
                failures.add("Role-auth file combination not valid.");
                Thread.sleep(10L);
                this.readFilesFromDisk(attemptLeft - 1, failures);
            }
        }
        catch (IOException | IllegalStateException | InterruptedException | InvalidArgumentsException e) {
            failures.add(e.getMessage());
            this.readFilesFromDisk(attemptLeft - 1, failures);
        }
    }

    private Set<String> ensureDefaultUsers() throws Throwable {
        if ((this.authenticationEnabled || this.authorizationEnabled) && this.userRepository.numberOfUsers() == 0) {
            User initUser;
            User neo4j = this.newUser("neo4j", "neo4j", true);
            if (this.initialUserRepository.numberOfUsers() > 0 && (initUser = this.initialUserRepository.getUserByName("neo4j")) != null) {
                this.userRepository.update(neo4j, initUser);
            }
            return Collections.singleton("neo4j");
        }
        return Collections.emptySet();
    }

    private void ensureDefaultRoles(Set<String> addedDefaultUsers) throws IOException, InvalidArgumentsException {
        if (this.authenticationEnabled || this.authorizationEnabled) {
            LinkedList<String> newAdmins = new LinkedList<String>(addedDefaultUsers);
            if (this.numberOfRoles() == 0) {
                if (newAdmins.isEmpty()) {
                    Set usernames = this.userRepository.getAllUsernames();
                    if (this.defaultAdminRepository.numberOfUsers() > 1) {
                        throw new InvalidArgumentsException("No roles defined, and multiple users defined as default admin user. Please use `neo4j-admin set-default-admin` to select a valid admin.");
                    }
                    if (this.defaultAdminRepository.numberOfUsers() == 1) {
                        String newAdminUsername = (String)this.defaultAdminRepository.getAllUsernames().iterator().next();
                        if (this.userRepository.getUserByName(newAdminUsername) == null) {
                            throw new InvalidArgumentsException("No roles defined, and default admin user '" + newAdminUsername + "' does not exist. Please use `neo4j-admin " + "set-default-admin" + "` to select a valid admin.");
                        }
                        newAdmins.add(newAdminUsername);
                    } else if (usernames.size() == 1) {
                        newAdmins.add((String)usernames.iterator().next());
                    } else if (usernames.contains("neo4j")) {
                        newAdmins.add("neo4j");
                    } else {
                        throw new InvalidArgumentsException("No roles defined, and cannot determine which user should be admin. Please use `neo4j-admin set-default-admin` to select an admin.");
                    }
                }
                for (String role : PredefinedRolesBuilder.roles.keySet()) {
                    this.newRole(role, new String[0]);
                }
            }
            for (String username : newAdmins) {
                this.addRoleToUser("admin", username);
            }
        }
    }

    @Override
    public void stop() throws Throwable {
        this.initialUserRepository.stop();
        this.defaultAdminRepository.stop();
        this.userRepository.stop();
        this.roleRepository.stop();
        if (this.reloadJobHandle != null) {
            this.reloadJobHandle.cancel(true);
            this.reloadJobHandle = null;
        }
    }

    @Override
    public void shutdown() throws Throwable {
        this.initialUserRepository.shutdown();
        this.defaultAdminRepository.shutdown();
        this.userRepository.shutdown();
        this.roleRepository.shutdown();
        this.setCacheManager(null);
    }

    public boolean supports(AuthenticationToken token) {
        try {
            if (token instanceof ShiroAuthToken) {
                ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
                return shiroAuthToken.getScheme().equals("basic") && shiroAuthToken.supportsRealm("native");
            }
            return false;
        }
        catch (InvalidAuthTokenException e) {
            return false;
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) throws AuthenticationException {
        if (!this.authorizationEnabled) {
            return null;
        }
        String username = (String)this.getAvailablePrincipal(principals);
        if (username == null) {
            return null;
        }
        User user = this.userRepository.getUserByName(username);
        if (user == null) {
            return null;
        }
        if (user.passwordChangeRequired() || user.hasFlag(IS_SUSPENDED)) {
            return new SimpleAuthorizationInfo();
        }
        Set<String> roles = this.roleRepository.getRoleNamesByUsername(user.name());
        return new SimpleAuthorizationInfo(roles);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String password;
        String username;
        if (!this.authenticationEnabled) {
            return null;
        }
        ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
        try {
            username = AuthToken.safeCast((String)"principal", shiroAuthToken.getAuthTokenMap());
            password = AuthToken.safeCast((String)"credentials", shiroAuthToken.getAuthTokenMap());
        }
        catch (InvalidAuthTokenException e) {
            throw new UnsupportedTokenException((Throwable)e);
        }
        User user = this.userRepository.getUserByName(username);
        if (user == null) {
            throw new UnknownAccountException();
        }
        AuthenticationResult result = this.authenticationStrategy.authenticate(user, password);
        switch (result) {
            case FAILURE: {
                throw new IncorrectCredentialsException();
            }
            case TOO_MANY_ATTEMPTS: {
                throw new ExcessiveAttemptsException();
            }
        }
        if (user.hasFlag(IS_SUSPENDED)) {
            throw new DisabledAccountException("User '" + user.name() + "' is suspended.");
        }
        if (user.passwordChangeRequired()) {
            result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
        }
        return new ShiroAuthenticationInfo(user.name(), this.getName(), result);
    }

    @Override
    public AuthorizationInfo getAuthorizationInfoSnapshot(PrincipalCollection principalCollection) {
        return this.getAuthorizationInfo(principalCollection);
    }

    private int numberOfUsers() {
        return this.userRepository.numberOfUsers();
    }

    private int numberOfRoles() {
        return this.roleRepository.numberOfRoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User newUser(String username, String initialPassword, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        this.userRepository.assertValidUsername(username);
        this.passwordPolicy.validatePassword(initialPassword);
        User user = new User.Builder().withName(username).withCredentials(Credential.forPassword((String)initialPassword)).withRequiredPasswordChange(requirePasswordChange).build();
        InternalFlatFileRealm internalFlatFileRealm = this;
        synchronized (internalFlatFileRealm) {
            this.userRepository.create(user);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleRecord newRole(String roleName, String ... usernames) throws IOException, InvalidArgumentsException {
        this.roleRepository.assertValidRoleName(roleName);
        for (String username : usernames) {
            this.userRepository.assertValidUsername(username);
        }
        TreeSet<String> userSet = new TreeSet<String>(Arrays.asList(usernames));
        RoleRecord role = new RoleRecord.Builder().withName(roleName).withUsers(userSet).build();
        InternalFlatFileRealm internalFlatFileRealm = this;
        synchronized (internalFlatFileRealm) {
            for (String username : usernames) {
                this.getUser(username);
            }
            this.roleRepository.create(role);
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRole(String roleName) throws IOException, InvalidArgumentsException {
        this.assertNotPredefinedRoleName(roleName);
        boolean result = false;
        InternalFlatFileRealm internalFlatFileRealm = this;
        synchronized (internalFlatFileRealm) {
            RoleRecord role = this.getRole(roleName);
            if (this.roleRepository.delete(role)) {
                result = true;
            } else {
                this.getRole(roleName);
            }
        }
        return result;
    }

    @Override
    public RoleRecord getRole(String roleName) throws InvalidArgumentsException {
        RoleRecord role = this.roleRepository.getRoleByName(roleName);
        if (role == null) {
            throw new InvalidArgumentsException("Role '" + roleName + "' does not exist.");
        }
        return role;
    }

    @Override
    public RoleRecord silentlyGetRole(String roleName) {
        return this.roleRepository.getRoleByName(roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoleToUser(String roleName, String username) throws IOException, InvalidArgumentsException {
        this.roleRepository.assertValidRoleName(roleName);
        this.userRepository.assertValidUsername(username);
        InternalFlatFileRealm internalFlatFileRealm = this;
        synchronized (internalFlatFileRealm) {
            this.getUser(username);
            RoleRecord role = this.getRole(roleName);
            RoleRecord newRole = role.augment().withUser(username).build();
            try {
                this.roleRepository.update(role, newRole);
            }
            catch (ConcurrentModificationException e) {
                this.addRoleToUser(roleName, username);
            }
        }
        this.clearCachedAuthorizationInfoForUser(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoleFromUser(String roleName, String username) throws IOException, InvalidArgumentsException {
        this.roleRepository.assertValidRoleName(roleName);
        this.userRepository.assertValidUsername(username);
        InternalFlatFileRealm internalFlatFileRealm = this;
        synchronized (internalFlatFileRealm) {
            this.getUser(username);
            RoleRecord role = this.getRole(roleName);
            RoleRecord newRole = role.augment().withoutUser(username).build();
            try {
                this.roleRepository.update(role, newRole);
            }
            catch (ConcurrentModificationException e) {
                this.removeRoleFromUser(roleName, username);
            }
        }
        this.clearCachedAuthorizationInfoForUser(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteUser(String username) throws IOException, InvalidArgumentsException {
        InternalFlatFileRealm internalFlatFileRealm = this;
        synchronized (internalFlatFileRealm) {
            User user = this.getUser(username);
            this.removeUserFromAllRoles(username);
            this.userRepository.delete(user);
        }
        this.clearCacheForUser(username);
        return true;
    }

    public User getUser(String username) throws InvalidArgumentsException {
        User u = this.userRepository.getUserByName(username);
        if (u == null) {
            throw new InvalidArgumentsException("User '" + username + "' does not exist.");
        }
        return u;
    }

    public User silentlyGetUser(String username) {
        return this.userRepository.getUserByName(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPassword(String username, String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        User existingUser = this.getUser(username);
        this.passwordPolicy.validatePassword(password);
        if (existingUser.credentials().matchesPassword(password)) {
            throw new InvalidArgumentsException("Old password and new password cannot be the same.");
        }
        try {
            User updatedUser = existingUser.augment().withCredentials(Credential.forPassword((String)password)).withRequiredPasswordChange(requirePasswordChange).build();
            InternalFlatFileRealm internalFlatFileRealm = this;
            synchronized (internalFlatFileRealm) {
                this.userRepository.update(existingUser, updatedUser);
            }
        }
        catch (ConcurrentModificationException e) {
            this.setUserPassword(username, password, requirePasswordChange);
        }
        this.clearCacheForUser(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendUser(String username) throws IOException, InvalidArgumentsException {
        User user = this.getUser(username);
        if (!user.hasFlag(IS_SUSPENDED)) {
            User suspendedUser = user.augment().withFlag(IS_SUSPENDED).build();
            try {
                InternalFlatFileRealm internalFlatFileRealm = this;
                synchronized (internalFlatFileRealm) {
                    this.userRepository.update(user, suspendedUser);
                }
            }
            catch (ConcurrentModificationException e) {
                this.suspendUser(username);
            }
        }
        this.clearCacheForUser(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateUser(String username, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        User user = this.getUser(username);
        if (user.hasFlag(IS_SUSPENDED)) {
            User activatedUser = user.augment().withoutFlag(IS_SUSPENDED).withRequiredPasswordChange(requirePasswordChange).build();
            try {
                InternalFlatFileRealm internalFlatFileRealm = this;
                synchronized (internalFlatFileRealm) {
                    this.userRepository.update(user, activatedUser);
                }
            }
            catch (ConcurrentModificationException e) {
                this.activateUser(username, requirePasswordChange);
            }
        }
        this.clearCacheForUser(username);
    }

    @Override
    public Set<String> getAllRoleNames() {
        return this.roleRepository.getAllRoleNames();
    }

    @Override
    public Set<String> getRoleNamesForUser(String username) throws InvalidArgumentsException {
        this.getUser(username);
        return this.roleRepository.getRoleNamesByUsername(username);
    }

    @Override
    public Set<String> silentlyGetRoleNamesForUser(String username) {
        return this.roleRepository.getRoleNamesByUsername(username);
    }

    @Override
    public Set<String> getUsernamesForRole(String roleName) throws InvalidArgumentsException {
        RoleRecord role = this.getRole(roleName);
        return role.users();
    }

    @Override
    public Set<String> silentlyGetUsernamesForRole(String roleName) {
        RoleRecord role = this.silentlyGetRole(roleName);
        return role == null ? Collections.emptySet() : role.users();
    }

    public Set<String> getAllUsernames() {
        return this.userRepository.getAllUsernames();
    }

    private void removeUserFromAllRoles(String username) throws IOException {
        try {
            this.roleRepository.removeUserFromAllRoles(username);
        }
        catch (ConcurrentModificationException e) {
            this.removeUserFromAllRoles(username);
        }
    }

    private void assertNotPredefinedRoleName(String roleName) throws InvalidArgumentsException {
        if (roleName != null && PredefinedRolesBuilder.roles.keySet().contains(roleName)) {
            throw new InvalidArgumentsException(String.format("'%s' is a predefined role and can not be deleted.", roleName));
        }
    }

    private void clearCachedAuthorizationInfoForUser(String username) {
        this.clearCachedAuthorizationInfo((PrincipalCollection)new SimplePrincipalCollection((Object)username, this.getName()));
    }

    private void clearCacheForUser(String username) {
        this.clearCache((PrincipalCollection)new SimplePrincipalCollection((Object)username, this.getName()));
    }
}

