/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.realm.ldap.DefaultLdapRealm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.graphdb.security.AuthProviderTimeoutException;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.security.enterprise.auth.PredefinedRolesBuilder;
import org.neo4j.server.security.enterprise.auth.RealmLifecycle;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;
import org.neo4j.server.security.enterprise.auth.ShiroAuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.ShiroAuthorizationInfoProvider;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class LdapRealm
extends DefaultLdapRealm
implements RealmLifecycle,
ShiroAuthorizationInfoProvider {
    private static final String GROUP_DELIMITER = ";";
    private static final String KEY_VALUE_DELIMITER = "=";
    private static final String ROLE_DELIMITER = ",";
    public static final String LDAP_REALM = "ldap";
    private static final String JNDI_LDAP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String JNDI_LDAP_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final String JNDI_LDAP_CONNECTION_TIMEOUT_MESSAGE_PART = "timed out";
    private static final String JNDI_LDAP_READ_TIMEOUT_MESSAGE_PART = "timed out";
    public static final String LDAP_CONNECTION_TIMEOUT_CLIENT_MESSAGE = "LDAP connection timed out.";
    public static final String LDAP_READ_TIMEOUT_CLIENT_MESSAGE = "LDAP response timed out.";
    public static final String LDAP_AUTHORIZATION_FAILURE_CLIENT_MESSAGE = "LDAP authorization request failed.";
    public static final String LDAP_CONNECTION_REFUSED_CLIENT_MESSAGE = "LDAP connection refused.";
    private Boolean authenticationEnabled;
    private Boolean authorizationEnabled;
    private Boolean useStartTls;
    private boolean useSAMAccountName;
    private String userSearchBase;
    private String userSearchFilter;
    private List<String> membershipAttributeNames;
    private Boolean useSystemAccountForAuthorization;
    private Map<String, Collection<String>> groupToRoleMapping;
    private final SecurityLog securityLog;
    private final SecureHasher secureHasher;
    private static final String KEY_GROUP = "\\s*('(.+)'|\"(.+)\"|(\\S)|(\\S.*\\S))\\s*";
    private static final String VALUE_GROUP = "\\s*(.*)";
    private Pattern keyValuePattern = Pattern.compile("\\s*('(.+)'|\"(.+)\"|(\\S)|(\\S.*\\S))\\s*=\\s*(.*)");

    public LdapRealm(Config config, SecurityLog securityLog, SecureHasher secureHasher) {
        this.securityLog = securityLog;
        this.secureHasher = secureHasher;
        this.setName(LDAP_REALM);
        this.setRolePermissionResolver(PredefinedRolesBuilder.rolePermissionResolver);
        this.configureRealm(config);
        if (this.isAuthenticationCachingEnabled()) {
            this.setCredentialsMatcher((CredentialsMatcher)secureHasher.getHashedCredentialsMatcher());
        } else {
            this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
        }
    }

    private String withRealm(String template, Object ... args) {
        return "{LdapRealm}: " + String.format(template, args);
    }

    private String server(JndiLdapContextFactory jndiLdapContextFactory) {
        return "'" + jndiLdapContextFactory.getUrl() + "'" + (this.useStartTls != false ? " using StartTLS" : "");
    }

    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        if (this.authenticationEnabled.booleanValue()) {
            if (this.useSAMAccountName) {
                return this.queryForAuthenticationInfoSAM(token, ldapContextFactory);
            }
            String serverString = this.server((JndiLdapContextFactory)ldapContextFactory);
            try {
                AuthenticationInfo info = this.useStartTls != false ? this.queryForAuthenticationInfoUsingStartTls(token, ldapContextFactory) : super.queryForAuthenticationInfo(token, ldapContextFactory);
                this.securityLog.debug(this.withRealm("Authenticated user '%s' against %s", token.getPrincipal(), serverString));
                return info;
            }
            catch (Exception e) {
                if (this.isExceptionAnLdapConnectionTimeout(e)) {
                    throw new AuthProviderTimeoutException(LDAP_CONNECTION_TIMEOUT_CLIENT_MESSAGE, (Throwable)e);
                }
                if (this.isExceptionAnLdapReadTimeout(e)) {
                    throw new AuthProviderTimeoutException(LDAP_READ_TIMEOUT_CLIENT_MESSAGE, (Throwable)e);
                }
                if (this.isExceptionConnectionRefused(e)) {
                    throw new AuthProviderFailedException(LDAP_CONNECTION_REFUSED_CLIENT_MESSAGE, (Throwable)e);
                }
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo queryForAuthenticationInfoUsingStartTls(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        AuthenticationInfo authenticationInfo;
        Object principal = this.getLdapPrincipal(token);
        Object credentials = token.getCredentials();
        LdapContext ctx = null;
        try {
            ctx = this.getLdapContextUsingStartTls(ldapContextFactory, principal, credentials);
            authenticationInfo = this.createAuthenticationInfo(token, principal, credentials, ctx);
        }
        catch (Throwable throwable) {
            LdapUtils.closeContext(ctx);
            throw throwable;
        }
        LdapUtils.closeContext((LdapContext)ctx);
        return authenticationInfo;
    }

    private LdapContext getLdapContextUsingStartTls(LdapContextFactory ldapContextFactory, Object principal, Object credentials) throws NamingException {
        JndiLdapContextFactory jndiLdapContextFactory = (JndiLdapContextFactory)ldapContextFactory;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", jndiLdapContextFactory.getContextFactoryClassName());
        env.put("java.naming.provider.url", jndiLdapContextFactory.getUrl());
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            StartTlsRequest startTlsRequest = new StartTlsRequest();
            StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(startTlsRequest);
            tls.negotiate();
            ctx.addToEnvironment("java.naming.security.authentication", jndiLdapContextFactory.getAuthenticationMechanism());
            ctx.addToEnvironment("java.naming.security.principal", principal);
            ctx.addToEnvironment("java.naming.security.credentials", credentials);
            return ctx;
        }
        catch (IOException e) {
            LdapUtils.closeContext(ctx);
            this.securityLog.error(this.withRealm("Failed to negotiate TLS connection with '%s': ", this.server(jndiLdapContextFactory), e));
            throw new CommunicationException(e.getMessage());
        }
        catch (Throwable t) {
            LdapUtils.closeContext(ctx);
            this.securityLog.error(this.withRealm("Unexpected failure to negotiate TLS connection with '%s': ", this.server(jndiLdapContextFactory), t));
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        if (this.authorizationEnabled.booleanValue()) {
            String username = this.getUsername(principals);
            if (username == null) {
                return null;
            }
            if (this.useSystemAccountForAuthorization.booleanValue()) {
                Set<String> roleNames;
                LdapContext ldapContext = this.useStartTls != false ? this.getSystemLdapContextUsingStartTls(ldapContextFactory) : ldapContextFactory.getSystemLdapContext();
                try {
                    roleNames = this.findRoleNamesForUser(username, ldapContext);
                }
                finally {
                    LdapUtils.closeContext((LdapContext)ldapContext);
                }
                return new SimpleAuthorizationInfo(roleNames);
            }
            Cache authorizationCache = this.getAuthorizationCache();
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)authorizationCache.get((Object)username);
            if (authorizationInfo == null) {
                throw new AuthorizationExpiredException("LDAP authorization info expired.");
            }
            return authorizationInfo;
        }
        return null;
    }

    private String getUsername(PrincipalCollection principals) {
        String username = null;
        Collection ldapPrincipals = principals.fromRealm(this.getName());
        if (!ldapPrincipals.isEmpty()) {
            username = (String)ldapPrincipals.iterator().next();
        } else if (this.useSystemAccountForAuthorization.booleanValue()) {
            username = (String)principals.getPrimaryPrincipal();
        }
        return username;
    }

    private LdapContext getSystemLdapContextUsingStartTls(LdapContextFactory ldapContextFactory) throws NamingException {
        JndiLdapContextFactory jndiLdapContextFactory = (JndiLdapContextFactory)ldapContextFactory;
        return this.getLdapContextUsingStartTls(ldapContextFactory, jndiLdapContextFactory.getSystemUsername(), jndiLdapContextFactory.getSystemPassword());
    }

    protected AuthenticationInfo createAuthenticationInfo(AuthenticationToken token, Object ldapPrincipal, Object ldapCredentials, LdapContext ldapContext) throws NamingException {
        if (this.authorizationEnabled.booleanValue() && !this.useSystemAccountForAuthorization.booleanValue()) {
            String username = (String)token.getPrincipal();
            Set<String> roleNames = this.findRoleNamesForUser(username, ldapContext);
            this.cacheAuthorizationInfo(username, roleNames);
        }
        if (this.isAuthenticationCachingEnabled()) {
            SimpleHash hashedCredentials = this.secureHasher.hash(((String)token.getCredentials()).getBytes());
            return new ShiroAuthenticationInfo(token.getPrincipal(), hashedCredentials.getBytes(), hashedCredentials.getSalt(), this.getName(), AuthenticationResult.SUCCESS);
        }
        return new ShiroAuthenticationInfo(token.getPrincipal(), this.getName(), AuthenticationResult.SUCCESS);
    }

    public boolean supports(AuthenticationToken token) {
        return this.supportsSchemeAndRealm(token);
    }

    private boolean supportsSchemeAndRealm(AuthenticationToken token) {
        try {
            if (token instanceof ShiroAuthToken) {
                ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
                return shiroAuthToken.getScheme().equals("basic") && shiroAuthToken.supportsRealm(LDAP_REALM);
            }
            return false;
        }
        catch (InvalidAuthTokenException e) {
            return false;
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        try {
            AuthorizationInfo info = super.doGetAuthorizationInfo(principals);
            this.securityLog.debug(this.withRealm("Queried for authorization info for user '%s'", principals.getPrimaryPrincipal()));
            return info;
        }
        catch (AuthorizationException e) {
            this.securityLog.error(this.withRealm("Failed to get authorization info: '%s' caused by '%s'", e.getMessage(), e.getCause().getMessage()));
            if (this.isAuthorizationExceptionAnLdapReadTimeout(e)) {
                throw new AuthProviderTimeoutException(LDAP_READ_TIMEOUT_CLIENT_MESSAGE, (Throwable)e);
            }
            throw new AuthProviderFailedException(LDAP_AUTHORIZATION_FAILURE_CLIENT_MESSAGE, (Throwable)e);
        }
    }

    private boolean isExceptionAnLdapReadTimeout(Exception e) {
        return e instanceof NamingException && e.getMessage().contains("timed out");
    }

    private boolean isExceptionAnLdapConnectionTimeout(Exception e) {
        return e instanceof CommunicationException && (((CommunicationException)e).getRootCause() instanceof SocketTimeoutException || ((CommunicationException)e).getRootCause().getMessage().contains("timed out"));
    }

    private boolean isExceptionConnectionRefused(Exception e) {
        return e instanceof CommunicationException && ((CommunicationException)e).getRootCause() instanceof ConnectException;
    }

    private boolean isAuthorizationExceptionAnLdapReadTimeout(AuthorizationException e) {
        return e.getCause() != null && e.getCause() instanceof NamingException && e.getCause().getMessage().contains("timed out");
    }

    private void cacheAuthorizationInfo(String username, Set<String> roleNames) {
        Cache authorizationCache = this.getAuthorizationCache();
        authorizationCache.put((Object)username, (Object)new SimpleAuthorizationInfo(roleNames));
    }

    private void configureRealm(Config config) {
        JndiLdapContextFactory contextFactory = new JndiLdapContextFactory();
        Map environment = contextFactory.getEnvironment();
        Long connectionTimeoutMillis = ((Duration)config.get(SecuritySettings.ldap_connection_timeout)).toMillis();
        Long readTimeoutMillis = ((Duration)config.get(SecuritySettings.ldap_read_timeout)).toMillis();
        environment.put(JNDI_LDAP_CONNECT_TIMEOUT, connectionTimeoutMillis.toString());
        environment.put(JNDI_LDAP_READ_TIMEOUT, readTimeoutMillis.toString());
        contextFactory.setEnvironment(environment);
        contextFactory.setUrl(this.parseLdapServerUrl((String)config.get(SecuritySettings.ldap_server)));
        contextFactory.setAuthenticationMechanism((String)config.get(SecuritySettings.ldap_authentication_mechanism));
        contextFactory.setReferral((String)config.get(SecuritySettings.ldap_referral));
        contextFactory.setSystemUsername((String)config.get(SecuritySettings.ldap_authorization_system_username));
        contextFactory.setSystemPassword((String)config.get(SecuritySettings.ldap_authorization_system_password));
        contextFactory.setPoolingEnabled(((Boolean)config.get(SecuritySettings.ldap_authorization_connection_pooling)).booleanValue());
        this.setContextFactory((LdapContextFactory)contextFactory);
        String userDnTemplate = (String)config.get(SecuritySettings.ldap_authentication_user_dn_template);
        if (userDnTemplate != null) {
            this.setUserDnTemplate(userDnTemplate);
        }
        this.authenticationEnabled = (Boolean)config.get(SecuritySettings.ldap_authentication_enabled);
        this.authorizationEnabled = (Boolean)config.get(SecuritySettings.ldap_authorization_enabled);
        this.useStartTls = (Boolean)config.get(SecuritySettings.ldap_use_starttls);
        this.userSearchBase = (String)config.get(SecuritySettings.ldap_authorization_user_search_base);
        this.userSearchFilter = (String)config.get(SecuritySettings.ldap_authorization_user_search_filter);
        this.useSAMAccountName = (Boolean)config.get(SecuritySettings.ldap_authentication_use_samaccountname);
        this.membershipAttributeNames = (List)config.get(SecuritySettings.ldap_authorization_group_membership_attribute_names);
        this.useSystemAccountForAuthorization = (Boolean)config.get(SecuritySettings.ldap_authorization_use_system_account);
        this.groupToRoleMapping = this.parseGroupToRoleMapping((String)config.get(SecuritySettings.ldap_authorization_group_to_role_mapping));
        this.setAuthenticationCachingEnabled((Boolean)config.get(SecuritySettings.ldap_authentication_cache_enabled));
        this.setAuthorizationCachingEnabled(true);
    }

    private String parseLdapServerUrl(String rawLdapServer) {
        return rawLdapServer == null ? null : (rawLdapServer.contains("://") ? rawLdapServer : "ldap://" + rawLdapServer);
    }

    private Map<String, Collection<String>> parseGroupToRoleMapping(String groupToRoleMappingString) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        if (groupToRoleMappingString != null) {
            for (String groupAndRoles : groupToRoleMappingString.split(GROUP_DELIMITER)) {
                String group;
                if (groupAndRoles.isEmpty()) continue;
                Matcher matcher = this.keyValuePattern.matcher(groupAndRoles);
                if (!matcher.find() || matcher.groupCount() != 6) {
                    String errorMessage = String.format("Failed to parse setting %s: wrong number of fields", SecuritySettings.ldap_authorization_group_to_role_mapping.name());
                    throw new IllegalArgumentException(errorMessage);
                }
                String string = matcher.group(2) != null ? matcher.group(2) : (matcher.group(3) != null ? matcher.group(3) : (matcher.group(4) != null ? matcher.group(4) : (group = matcher.group(5) != null ? matcher.group(5) : "")));
                if (group.isEmpty()) {
                    String errorMessage = String.format("Failed to parse setting %s: empty group name", SecuritySettings.ldap_authorization_group_to_role_mapping.name());
                    throw new IllegalArgumentException(errorMessage);
                }
                ArrayList<String> roleList = new ArrayList<String>();
                for (String role : matcher.group(6).trim().split(ROLE_DELIMITER)) {
                    if (role.isEmpty()) continue;
                    roleList.add(role);
                }
                map.put(group.toLowerCase(), roleList);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationInfo queryForAuthenticationInfoSAM(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        AuthenticationInfo authenticationInfo;
        Object principal = token.getPrincipal();
        Object credentials = token.getCredentials();
        LdapContext ctx = null;
        try {
            String loginUser;
            ctx = this.useStartTls != false ? this.getSystemLdapContextUsingStartTls(ldapContextFactory) : ldapContextFactory.getSystemLdapContext();
            String[] attrs = new String[]{"cn"};
            SearchControls searchCtls = new SearchControls(2, 1L, 0, attrs, false, false);
            Object[] searchArguments = new Object[]{principal};
            String filter = "sAMAccountName={0}";
            NamingEnumeration<SearchResult> search = ctx.search(this.userSearchBase, filter, searchArguments, searchCtls);
            if (search.hasMore()) {
                SearchResult next = search.next();
                loginUser = next.getNameInNamespace();
                if (search.hasMore()) {
                    this.securityLog.error("More than one user matching: " + principal);
                    throw new AuthenticationException("More than one user matching: " + principal);
                }
            } else {
                throw new AuthenticationException("No user matching: " + principal);
            }
            LdapContext ctx2 = ldapContextFactory.getLdapContext((Object)loginUser, credentials);
            LdapUtils.closeContext((LdapContext)ctx2);
            authenticationInfo = this.createAuthenticationInfo(token, principal, credentials, ctx);
        }
        catch (Throwable throwable) {
            LdapUtils.closeContext(ctx);
            throw throwable;
        }
        LdapUtils.closeContext((LdapContext)ctx);
        return authenticationInfo;
    }

    Set<String> findRoleNamesForUser(String username, LdapContext ldapContext) throws NamingException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(this.membershipAttributeNames.toArray(new String[1]));
        Object[] searchArguments = new Object[]{username};
        NamingEnumeration<SearchResult> result = ldapContext.search(this.userSearchBase, this.userSearchFilter, searchArguments, searchCtls);
        if (result.hasMoreElements()) {
            Attributes attributes;
            SearchResult searchResult = result.next();
            if (result.hasMoreElements()) {
                this.securityLog.warn(this.securityLog.isDebugEnabled() ? this.withRealm("LDAP user search for user principal '%s' is ambiguous. The first match that will be checked for group membership is '%s' but the search also matches '%s'. Please check your LDAP realm configuration.", username, searchResult.toString(), ((Object)result.next()).toString()) : this.withRealm("LDAP user search for user principal '%s' is ambiguous. The search matches more than one entry. Please check your LDAP realm configuration.", username));
            }
            if ((attributes = searchResult.getAttributes()) != null) {
                NamingEnumeration<? extends Attribute> attributeEnumeration = attributes.getAll();
                while (attributeEnumeration.hasMore()) {
                    Attribute attribute = attributeEnumeration.next();
                    String attributeId = attribute.getID();
                    if (!this.membershipAttributeNames.stream().anyMatch(attributeId::equalsIgnoreCase)) continue;
                    Collection groupNames = LdapUtils.getAllAttributeValues((Attribute)attribute);
                    Collection<String> rolesForGroups = this.getRoleNamesForGroups(groupNames);
                    roleNames.addAll(rolesForGroups);
                }
            }
        }
        return roleNames;
    }

    private void assertValidUserSearchSettings() {
        boolean proceedWithSearch = true;
        if (this.userSearchBase == null || this.userSearchBase.isEmpty()) {
            this.securityLog.error("LDAP user search base is empty.");
            proceedWithSearch = false;
        }
        if (this.userSearchFilter == null || !this.userSearchFilter.contains("{0}")) {
            this.securityLog.warn("LDAP user search filter does not contain the argument placeholder {0}, so the search result will be independent of the user principal.");
        }
        if (this.membershipAttributeNames == null || this.membershipAttributeNames.isEmpty()) {
            this.securityLog.error("LDAP group membership attribute names are empty. Authorization will not be possible.");
            proceedWithSearch = false;
        }
        if (!proceedWithSearch) {
            throw new IllegalArgumentException("Illegal LDAP user search settings, see security log for details.");
        }
    }

    private Collection<String> getRoleNamesForGroups(Collection<String> groupNames) {
        ArrayList<String> roles = new ArrayList<String>();
        for (String group : groupNames) {
            Collection<String> rolesForGroup = this.groupToRoleMapping.get(group.toLowerCase());
            if (rolesForGroup == null) continue;
            roles.addAll(rolesForGroup);
        }
        return roles;
    }

    Map<String, Collection<String>> getGroupToRoleMapping() {
        return this.groupToRoleMapping;
    }

    @Override
    public void initialize() {
        if (this.authorizationEnabled.booleanValue()) {
            this.assertValidUserSearchSettings();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public AuthorizationInfo getAuthorizationInfoSnapshot(PrincipalCollection principalCollection) {
        return this.getAuthorizationInfo(principalCollection);
    }
}

