/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Settings for the remote shell extension")
public class ShellSettings
implements LoadableConfig {
    @Description(value="Enable a remote shell server which Neo4j Shell clients can log in to. Only applicable to `neo4j-shell`.")
    public static final Setting<Boolean> remote_shell_enabled = Settings.setting((String)"dbms.shell.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Remote host for shell. By default, the shell server listens only on the loopback interface, but you can specify the IP address of any network interface or use `0.0.0.0` for all interfaces. Only applicable to `neo4j-shell`.")
    public static final Setting<String> remote_shell_host = Settings.buildSetting((String)"dbms.shell.host", (Function)Settings.STRING, (String)"127.0.0.1").constraint(Settings.illegalValueMessage((String)"must be a valid name", (BiFunction)Settings.matches((String)".+"))).build();
    @Description(value="The port the shell will listen on. Only applicable to `neo4j-shell`.")
    public static final Setting<Integer> remote_shell_port = Settings.buildSetting((String)"dbms.shell.port", (Function)Settings.INTEGER, (String)"1337").constraint(Settings.port).build();
    @Description(value="Read only mode. Will only allow read operations. Only applicable to `neo4j-shell`.")
    public static final Setting<Boolean> remote_shell_read_only = Settings.setting((String)"dbms.shell.read_only", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The name of the shell. Only applicable to `neo4j-shell`.")
    public static final Setting<String> remote_shell_name = Settings.buildSetting((String)"dbms.shell.rmi_name", (Function)Settings.STRING, (String)"shell").constraint(Settings.illegalValueMessage((String)"must be a valid name", (BiFunction)Settings.matches((String)".+"))).build();
}

