/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptExecutor;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJavaScriptExecutor
implements JavaScriptExecutor {
    private static final long serialVersionUID = 5677978210585334168L;
    private final transient WeakReference<WebClient> webClient_;
    private final transient List<WeakReference<JavaScriptJobManager>> jobManagerList_ = new LinkedList<WeakReference<JavaScriptJobManager>>();
    private volatile boolean shutdown_ = false;
    private transient Thread eventLoopThread_ = null;
    private static final Log LOG = LogFactory.getLog(DefaultJavaScriptExecutor.class);

    public DefaultJavaScriptExecutor(WebClient webClient) {
        this.webClient_ = new WeakReference<WebClient>(webClient);
    }

    protected void startThreadIfNeeded() {
        if (this.eventLoopThread_ == null) {
            this.eventLoopThread_ = new Thread((Runnable)this, this.getThreadName());
            this.eventLoopThread_.setDaemon(true);
            this.eventLoopThread_.start();
        }
    }

    protected String getThreadName() {
        return "JS executor for " + this.webClient_.get();
    }

    private void killThread() {
        if (this.eventLoopThread_ == null) {
            return;
        }
        try {
            this.eventLoopThread_.interrupt();
            this.eventLoopThread_.join(10000L);
        }
        catch (InterruptedException e) {
            LOG.warn("InterruptedException while waiting for the eventLoop thread to join ", e);
        }
        if (this.eventLoopThread_.isAlive()) {
            LOG.warn("Event loop thread " + this.eventLoopThread_.getName() + " still alive at " + System.currentTimeMillis());
        }
    }

    protected synchronized JavaScriptJobManager getJobManagerWithEarliestJob() {
        JavaScriptJobManager javaScriptJobManager = null;
        JavaScriptJob earliestJob = null;
        Iterator<WeakReference<JavaScriptJobManager>> managers = this.jobManagerList_.iterator();
        while (managers.hasNext()) {
            JavaScriptJobManager jobManager = (JavaScriptJobManager)managers.next().get();
            if (jobManager == null) {
                managers.remove();
                continue;
            }
            JavaScriptJob newJob = jobManager.getEarliestJob();
            if (newJob == null || earliestJob != null && earliestJob.compareTo(newJob) <= 0) continue;
            earliestJob = newJob;
            javaScriptJobManager = jobManager;
        }
        return javaScriptJobManager;
    }

    @Override
    public int pumpEventLoop(long timeoutMillis) {
        return 0;
    }

    @Override
    public void run() {
        boolean trace = LOG.isTraceEnabled();
        long sleepInterval = 10L;
        while (!this.shutdown_ && this.webClient_.get() != null) {
            long waitTime;
            JavaScriptJob earliestJob;
            if (trace) {
                LOG.trace("started finding earliestJob at " + System.currentTimeMillis());
            }
            JavaScriptJobManager jobManager = this.getJobManagerWithEarliestJob();
            if (trace) {
                LOG.trace("stopped finding earliestJob at " + System.currentTimeMillis());
            }
            if (jobManager != null && (earliestJob = jobManager.getEarliestJob()) != null && (waitTime = earliestJob.getTargetExecutionTime() - System.currentTimeMillis()) < 1L) {
                if (trace) {
                    LOG.trace("started executing job at " + System.currentTimeMillis());
                }
                jobManager.runSingleJob(earliestJob);
                if (!trace) continue;
                LOG.trace("stopped executing job at " + System.currentTimeMillis());
                continue;
            }
            if (this.shutdown_ || this.webClient_.get() == null) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
    }

    @Override
    public synchronized void addWindow(WebWindow newWindow) {
        JavaScriptJobManager jobManager = newWindow.getJobManager();
        if (jobManager != null && !this.contains(jobManager)) {
            this.jobManagerList_.add(new WeakReference<JavaScriptJobManager>(jobManager));
            this.startThreadIfNeeded();
        }
    }

    private boolean contains(JavaScriptJobManager newJobManager) {
        for (WeakReference<JavaScriptJobManager> jobManagerRef : this.jobManagerList_) {
            if (jobManagerRef.get() != newJobManager) continue;
            return true;
        }
        return false;
    }

    @Override
    public void shutdown() {
        this.shutdown_ = true;
        this.killThread();
        this.webClient_.clear();
        this.jobManagerList_.clear();
    }
}

