/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.CDATASection;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class XMLSerializer
extends SimpleScriptable {
    private static final Set<String> NON_EMPTY_TAGS = new HashSet<String>(Arrays.asList("abbr", "acronym", "a", "applet", "address", "audio", "bgsound", "bdo", "big", "blink", "blockquote", "body", "b", "button", "canvas", "caption", "center", "cite", "code", "dfn", "dd", "del", "dir", "div", "dl", "dt", "embed", "em", "fieldset", "font", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "html", "iframe", "ins", "isindex", "i", "kbd", "label", "legend", "listing", "li", "map", "marquee", "menu", "multicol", "nobr", "noembed", "noframes", "noscript", "object", "ol", "optgroup", "option", "p", "plaintext", "pre", "q", "s", "samp", "script", "select", "small", "source", "span", "strike", "strong", "style", "sub", "sup", "title", "table", "col", "colgroup", "tbody", "td", "th", "tr", "textarea", "tfoot", "thead", "tt", "u", "ul", "var", "video", "wbr", "xmp"));

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxFunction
    public String serializeToString(Node root) {
        DomCDataSection domCData;
        String data;
        if (root == null) {
            return "";
        }
        if (root instanceof Document) {
            root = ((Document)root).getDocumentElement();
        } else if (root instanceof DocumentFragment) {
            if (root.getOwnerDocument() instanceof HTMLDocument && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SERIALIZER_HTML_DOCUMENT_FRAGMENT_ALWAYS_EMPTY)) {
                return "";
            }
            root = root.getFirstChild();
        }
        if (root instanceof Element) {
            StringBuilder buffer = new StringBuilder();
            Object node = root.getDomNodeOrDie();
            SgmlPage page = ((DomNode)node).getPage();
            boolean isHtmlPage = page != null && page.isHtmlPage();
            boolean appendCrlf = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SERIALIZER_APPENDS_CRLF);
            boolean addXhtmlNamespace = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SERIALIZER_ADD_XHTML_NAMESPACE);
            String forcedNamespace = null;
            if (addXhtmlNamespace && isHtmlPage) {
                forcedNamespace = "http://www.w3.org/1999/xhtml";
            }
            this.toXml(1, (DomNode)node, buffer, forcedNamespace, appendCrlf);
            if (appendCrlf) {
                buffer.append("\r\n");
            }
            return buffer.toString();
        }
        if (root instanceof CDATASection && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SERIALIZER_ROOT_CDATA_AS_ESCAPED_TEXT) && StringUtils.isNotBlank(data = (domCData = (DomCDataSection)root.getDomNodeOrDie()).getData())) {
            return com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlChars(data);
        }
        return ((DomNode)root.getDomNodeOrDie()).asXml();
    }

    private void toXml(int indent, DomNode node, StringBuilder buffer, String foredNamespace, boolean appendCrLf) {
        String nodeName = node.getNodeName();
        buffer.append('<').append(nodeName);
        String optionalPrefix = "";
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (namespaceURI != null && prefix != null) {
            boolean sameNamespace = false;
            DomNode parentNode = node.getParentNode();
            while (parentNode instanceof DomElement) {
                if (namespaceURI.equals(parentNode.getNamespaceURI())) {
                    sameNamespace = true;
                }
                parentNode = parentNode.getParentNode();
            }
            if (node.getParentNode() == null || !sameNamespace) {
                ((DomElement)node).setAttribute("xmlns:" + prefix, namespaceURI);
            }
        } else if (foredNamespace != null) {
            buffer.append(" xmlns=\"").append(foredNamespace).append('\"');
            optionalPrefix = " ";
        }
        NamedNodeMap attributesMap = node.getAttributes();
        for (int i = 0; i < attributesMap.getLength(); ++i) {
            DomAttr attrib = (DomAttr)attributesMap.item(i);
            buffer.append(' ').append(attrib.getQualifiedName()).append('=').append('\"').append(attrib.getValue()).append('\"');
        }
        boolean startTagClosed = false;
        block7: for (DomNode child : node.getChildren()) {
            if (!startTagClosed) {
                buffer.append(optionalPrefix).append('>');
                startTagClosed = true;
            }
            switch (child.getNodeType()) {
                case 1: {
                    this.toXml(indent + 1, child, buffer, null, appendCrLf);
                    break;
                }
                case 3: {
                    String value = child.getNodeValue();
                    value = com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlChars(value);
                    if (appendCrLf && StringUtils.isBlank(value)) {
                        buffer.append("\r\n");
                        DomNode sibling = child.getNextSibling();
                        if (sibling == null || sibling.getNodeType() != 1) continue block7;
                        for (int i = 0; i < indent; ++i) {
                            buffer.append('\t');
                        }
                        continue block7;
                    }
                    buffer.append(value);
                    break;
                }
                case 4: 
                case 8: {
                    buffer.append(child.asXml());
                    break;
                }
            }
        }
        if (!startTagClosed) {
            String tagName = nodeName.toLowerCase(Locale.ENGLISH);
            boolean nonEmptyTagsSupported = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SERIALIZER_NON_EMPTY_TAGS);
            if (nonEmptyTagsSupported && NON_EMPTY_TAGS.contains(tagName)) {
                buffer.append('>');
                buffer.append("</").append(nodeName).append('>');
            } else {
                buffer.append(optionalPrefix);
                if (buffer.charAt(buffer.length() - 1) != ' ' && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SERIALIZER_BLANK_BEFORE_SELF_CLOSING)) {
                    buffer.append(" ");
                }
                buffer.append("/>");
            }
        } else {
            buffer.append('<').append('/').append(nodeName).append('>');
        }
    }
}

