/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.proxy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.RemoteException;
import org.openqa.grid.common.exception.RemoteNotReachableException;
import org.openqa.grid.common.exception.RemoteUnregisterException;
import org.openqa.grid.internal.BaseRemoteProxy;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.CommandListener;
import org.openqa.grid.internal.listeners.SelfHealingProxy;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.internal.listeners.TimeoutListener;
import org.openqa.grid.internal.utils.HtmlRenderer;
import org.openqa.grid.selenium.utils.WebProxyHtmlRenderer;

public class DefaultRemoteProxy
extends BaseRemoteProxy
implements TimeoutListener,
SelfHealingProxy,
CommandListener,
TestSessionListener {
    private static final Logger log = Logger.getLogger(DefaultRemoteProxy.class.getName());
    public static final int DEFAULT_POLLING_INTERVAL = 10000;
    public static final int DEFAULT_UNREGISTER_DELAY = 60000;
    public static final int DEFAULT_DOWN_POLLING_LIMIT = 2;
    private volatile int pollingInterval = 10000;
    private volatile int unregisterDelay = 60000;
    private volatile int downPollingLimit = 2;
    private final HtmlRenderer renderer = new WebProxyHtmlRenderer(this);
    private volatile boolean down = false;
    private volatile boolean poll = true;
    private List<RemoteException> errors = new CopyOnWriteArrayList<RemoteException>();
    private Thread pollingThread = null;

    public DefaultRemoteProxy(RegistrationRequest request, Registry registry) {
        super(request, registry);
        this.pollingInterval = request.getConfigAsInt("nodePolling", 10000);
        this.unregisterDelay = request.getConfigAsInt("unregisterIfStillDownAfter", 60000);
        this.downPollingLimit = request.getConfigAsInt("downPollingLimit", 2);
    }

    @Override
    public void beforeRelease(TestSession session) {
        if (session.getExternalKey() == null) {
            return;
        }
        boolean ok = session.sendDeleteSessionRequest();
        if (!ok) {
            log.warning("Error releasing the resources on timeout for session " + session);
        }
    }

    @Override
    public void afterCommand(TestSession session, HttpServletRequest request, HttpServletResponse response) {
        session.put("lastCommand", String.valueOf(request.getMethod()) + " - " + request.getPathInfo() + " executing ...");
    }

    @Override
    public void beforeCommand(TestSession session, HttpServletRequest request, HttpServletResponse response) {
        session.put("lastCommand", String.valueOf(request.getMethod()) + " - " + request.getPathInfo() + " executed.");
    }

    @Override
    public HtmlRenderer getHtmlRender() {
        return this.renderer;
    }

    public boolean isAlive() {
        try {
            this.getStatus();
            return true;
        }
        catch (Exception e) {
            log.warning("Failed to check status of node: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void startPolling() {
        this.pollingThread = new Thread(new Runnable(){
            int failedPollingTries = 0;
            long downSince = 0L;

            @Override
            public void run() {
                while (DefaultRemoteProxy.this.poll) {
                    try {
                        Thread.sleep(DefaultRemoteProxy.this.pollingInterval);
                        if (!DefaultRemoteProxy.this.isAlive()) {
                            if (!DefaultRemoteProxy.this.down) {
                                ++this.failedPollingTries;
                                if (this.failedPollingTries < DefaultRemoteProxy.this.downPollingLimit) continue;
                                this.downSince = System.currentTimeMillis();
                                DefaultRemoteProxy.this.addNewEvent(new RemoteNotReachableException("Marking the node as down. Cannot reach the node for " + this.failedPollingTries + " tries."));
                                continue;
                            }
                            long downFor = System.currentTimeMillis() - this.downSince;
                            if (downFor <= (long)DefaultRemoteProxy.this.unregisterDelay) continue;
                            DefaultRemoteProxy.this.addNewEvent(new RemoteUnregisterException("Unregistering the node. It's been down for " + downFor + " milliseconds."));
                            continue;
                        }
                        DefaultRemoteProxy.this.down = false;
                        this.failedPollingTries = 0;
                        this.downSince = 0L;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        }, "RemoteProxy failure poller thread for " + this.getId());
        this.pollingThread.start();
    }

    @Override
    public void stopPolling() {
        this.poll = false;
        this.pollingThread.interrupt();
    }

    @Override
    public void addNewEvent(RemoteException event) {
        this.errors.add(event);
        this.onEvent(this.errors, event);
    }

    @Override
    public void onEvent(List<RemoteException> events, RemoteException lastInserted) {
        for (RemoteException e : events) {
            if (e instanceof RemoteNotReachableException) {
                log.warning(e.getMessage());
                this.down = true;
                this.errors.clear();
            }
            if (!(e instanceof RemoteUnregisterException)) continue;
            log.warning(e.getMessage());
            Registry registry = this.getRegistry();
            registry.removeIfPresent(this);
        }
    }

    @Override
    public TestSession getNewSession(Map<String, Object> requestedCapability) {
        if (this.down) {
            return null;
        }
        return super.getNewSession(requestedCapability);
    }

    public boolean isDown() {
        return this.down;
    }

    @Override
    public void beforeSession(TestSession session) {
        if (session.getSlot().getProtocol() == SeleniumProtocol.WebDriver) {
            Map<String, Object> cap = session.getRequestedCapabilities();
            if ("firefox".equals(cap.get("browserName")) && session.getSlot().getCapabilities().get("firefox_binary") != null && cap.get("firefox_binary") == null) {
                session.getRequestedCapabilities().put("firefox_binary", session.getSlot().getCapabilities().get("firefox_binary"));
            }
            if ("chrome".equals(cap.get("browserName")) && session.getSlot().getCapabilities().get("chrome_binary") != null) {
                JSONObject options = (JSONObject)cap.get("chromeOptions");
                if (options == null) {
                    options = new JSONObject();
                }
                try {
                    options.put("binary", session.getSlot().getCapabilities().get("chrome_binary"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                cap.put("chromeOptions", options);
            }
            if ("opera".equals(cap.get("browserName")) && session.getSlot().getCapabilities().get("opera_binary") != null && cap.get("opera.binary") == null) {
                session.getRequestedCapabilities().put("opera.binary", session.getSlot().getCapabilities().get("opera_binary"));
            }
        }
    }

    @Override
    public void afterSession(TestSession session) {
    }

    @Override
    public void teardown() {
        super.teardown();
        this.stopPolling();
    }
}

