/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.config;

import com.xylink.config.SDKConfig;
import com.xylink.util.SslUtils;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.map.ObjectMapper;

public class SDKConfigMgr {
    private static final String CONFIG_FILE = "/com/xylink/config/config.json";
    private static String DEFAULT_SERVER_HOST = "https://sdk.xylink.com";
    private static SDKConfig sdkConfig;
    private static final ObjectMapper objectMapper;

    public static String getServerHost() {
        return sdkConfig.getServerHost();
    }

    public static void setServerHost(String host) {
        if (host == null || host.trim().isEmpty()) {
            throw new IllegalArgumentException("host cannot be empty.");
        }
        if (!DEFAULT_SERVER_HOST.equals(host.toLowerCase().trim())) {
            try {
                SslUtils.ignoreSsl();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to ignore ssl cert.", e);
            }
        }
        sdkConfig.setServerHost(host);
    }

    private static SDKConfig loadConfigs() {
        try {
            InputStream inputStream = SDKConfigMgr.class.getResourceAsStream(CONFIG_FILE);
            SDKConfig sdkConfig = (SDKConfig)objectMapper.readValue(inputStream, SDKConfig.class);
            return sdkConfig;
        }
        catch (IOException e) {
            return new SDKConfig();
        }
    }

    static {
        objectMapper = new ObjectMapper();
        sdkConfig = SDKConfigMgr.loadConfigs();
        if (sdkConfig == null) {
            sdkConfig = new SDKConfig();
            sdkConfig.setServerHost(DEFAULT_SERVER_HOST);
        }
    }
}

