/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.callback;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.callback.CallbackEvent;
import com.xylink.model.callback.ExternalCallback;
import com.xylink.model.callback.RosterCallback;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

public class CallBacksApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/";

    public Result<ExternalCallback[]> getExternalCallbacks(String enterpriseId, String token) throws IOException {
        String surl = this.getPrefixUrl() + "callbacks?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", ExternalCallback[].class);
    }

    public Result regExternalCallback(String enterpriseId, String token, ExternalCallback externalCallback) throws IOException {
        String surl = this.getPrefixUrl() + "callbacks?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)externalCallback);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, null);
    }

    public Result updateExternalCallback(String enterpriseId, String token, ExternalCallback externalCallback) throws IOException {
        String surl = this.getPrefixUrl() + "callbacks/" + externalCallback.getCallbackEvent().name() + "?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)externalCallback);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result removeExternalCallback(String enterpriseId, String token, CallbackEvent callbackEvent) throws IOException {
        String surl = this.getPrefixUrl() + "callbacks/" + callbackEvent.name() + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", "", null);
    }

    public Result<RosterCallback[]> getRosterCallbacks(String enterpriseId, String token) throws IOException {
        String surl = this.getPrefixUrl() + "callbacks/roster?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", RosterCallback[].class);
    }

    public Result regRosterCallback(String enterpriseId, String token, String confNumber, RosterCallback rosterCallback) throws IOException {
        String surl = this.getPrefixUrl() + "callbacks/roster/" + confNumber + "?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)rosterCallback);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, CallbackEvent[].class);
    }

    public Result removeRosterCallback(String enterpriseId, String token, String confNumber) throws IOException {
        String surl = this.getPrefixUrl() + "callbacks/roster/" + confNumber + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", "", CallbackEvent[].class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

