/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.conferenceControl;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.MeetingInfo;
import com.xylink.model.Pager;
import com.xylink.model.SdkCloudMeetingRoomRequest;
import com.xylink.model.SdkMeeting;
import com.xylink.model.SdkMeetingReq;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class CreateMeetingApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrlMeetingInfo = "/api/rest/external/v1/meetingInfo/";

    @Deprecated
    public SdkMeeting createMeeting(String enterpriseId, String token, SdkMeetingReq sdkMeetingReq) throws IOException {
        String url = SDKConfigMgr.getServerHost() + "/api/rest/external/v1/create_meeting?enterprise_id=" + enterpriseId;
        if (sdkMeetingReq == null || sdkMeetingReq.getMeetingName() == null) {
            return null;
        }
        url = url + "&meeting_name=" + URLEncoder.encode(sdkMeetingReq.getMeetingName(), "utf-8");
        url = url + "&start_time=" + sdkMeetingReq.getStartTime();
        url = url + "&end_time=" + (sdkMeetingReq.getStartTime() + sdkMeetingReq.getDuration());
        if (null != sdkMeetingReq.getMaxParticipantCount() && sdkMeetingReq.getMaxParticipantCount() > 0) {
            url = url + "&max_participant=" + sdkMeetingReq.getMaxParticipantCount();
        }
        url = url + "&require_password=" + sdkMeetingReq.isRequirePassword();
        url = url + "&autoRecord=" + sdkMeetingReq.isAutoRecord();
        if (sdkMeetingReq.getPassword() != null && !sdkMeetingReq.getPassword().trim().isEmpty()) {
            url = url + "&password=" + sdkMeetingReq.getPassword();
        }
        if (sdkMeetingReq.getControlPassword() != null && !sdkMeetingReq.getControlPassword().trim().isEmpty()) {
            url = url + "&controlPassword=" + sdkMeetingReq.getControlPassword();
        }
        if (sdkMeetingReq.getMeetingNumber() != null && !sdkMeetingReq.getMeetingNumber().trim().isEmpty()) {
            url = url + "&meetingNumber=" + sdkMeetingReq.getMeetingNumber();
        }
        url = url + "&autoMute=" + sdkMeetingReq.getAutoMute();
        if (sdkMeetingReq.getSmartMutePerson() != 0) {
            url = url + "&smartMutePerson=" + sdkMeetingReq.getSmartMutePerson();
        }
        String signature = new SignatureSample().computeSignature("", "GET", token, url);
        url = url + "&signature=" + signature;
        Result sdkMeeting = HttpUtil.getResponse(url, "GET", "", SdkMeeting.class);
        if (sdkMeeting.isSuccess()) {
            return (SdkMeeting)sdkMeeting.getData();
        }
        throw new RuntimeException(sdkMeeting.getErrorStatus() + "");
    }

    public SdkMeeting createMeetingV2(String enterpriseId, String token, SdkCloudMeetingRoomRequest sdkCloudMeetingRoomRequest) throws IOException {
        String url = SDKConfigMgr.getServerHost() + "/api/rest/external/v2/create_meeting?enterpriseId=" + enterpriseId;
        if (sdkCloudMeetingRoomRequest == null || sdkCloudMeetingRoomRequest.getMeetingName() == null) {
            return null;
        }
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)sdkCloudMeetingRoomRequest);
        String signature = new SignatureSample().computeSignature(jsonEntity, "POST", token, url);
        url = url + "&signature=" + signature;
        Result sdkMeeting = HttpUtil.getResponse(url, "POST", jsonEntity, SdkMeeting.class);
        if (sdkMeeting.isSuccess()) {
            return (SdkMeeting)sdkMeeting.getData();
        }
        throw new RuntimeException(sdkMeeting.getErrorStatus() + "");
    }

    public Result<MeetingInfo> getMeetingInfo(String enterpriseId, String token, String meetingRoomNumber) throws IOException {
        String surl = this.getMeetingInfoPrefixUrl() + meetingRoomNumber + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, MeetingInfo.class);
    }

    public Result updateMeetingInfo(String enterpriseId, String token, String meetingRoomNumber, MeetingInfo meetingInfo) throws IOException {
        String surl = this.getMeetingInfoPrefixUrl() + meetingRoomNumber + "?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)meetingInfo);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result<MeetingInfo[]> getBatchMeetingInfo(String enterpriseId, String token, String[] meetingRoomNumbers) throws IOException {
        String surl = this.getMeetingInfoPrefixUrl() + "batch?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)meetingRoomNumbers);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, MeetingInfo[].class);
    }

    public Result deleteMeetingInfo(String enterpriseId, String token, String meetingRoomNumber) throws IOException {
        String surl = this.getMeetingInfoPrefixUrl() + meetingRoomNumber + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", null, null);
    }

    @Deprecated
    public Result<MeetingInfo[]> getSdkMeetingRooms(String enterpriseId, String token) throws IOException {
        String surl = this.getMeetingInfoPrefixUrl() + enterpriseId + "/meetingRoomInfo?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, MeetingInfo[].class);
    }

    public Result<Pager<MeetingInfo>> getSdkMeetingRooms(String enterpriseId, String token, int page, int size) throws IOException {
        String surl = this.getMeetingInfoPrefixUrl() + enterpriseId + "/meetingRoomInfo/page?enterpriseId=" + enterpriseId + "&pageIndex=" + page + "&pageSize=" + size;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        Result resp = HttpUtil.getResponse(surl, "GET", null, String.class);
        Result<Pager<MeetingInfo>> result = new Result<Pager<MeetingInfo>>();
        result.setSuccess(resp.isSuccess());
        result.setErrorStatus(resp.getErrorStatus());
        result.setErrorMsg(resp.getErrorMsg());
        if (resp.isSuccess() && StringUtils.isNotBlank((CharSequence)((CharSequence)resp.getData()))) {
            ObjectMapper objectMapper = new ObjectMapper();
            Pager pager = (Pager)objectMapper.readValue((String)resp.getData(), (TypeReference)new TypeReference<Pager<MeetingInfo>>(){});
            result.setData(pager);
        }
        return result;
    }

    private String getMeetingInfoPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrlMeetingInfo;
    }
}

