/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.dating;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.Pager;
import com.xylink.model.ReminderMeeting;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class ScheduleMeetingApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/meetingreminders";

    public Result remindMeeting(String enterpriseId, String token, ReminderMeeting reminderMeeting, int maxParticipantCount) throws IOException {
        String surl = this.getPrefixUrl() + "?enterpriseId=" + enterpriseId + "&maxParticipant=" + maxParticipantCount;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)reminderMeeting);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, Map.class);
    }

    public Result remindMeeting(String enterpriseId, String token, ReminderMeeting reminderMeeting) throws IOException {
        String surl = this.getPrefixUrl() + "?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)reminderMeeting);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, Map.class);
    }

    public Result updateMeeting(String enterpriseId, String token, String meetingId, ReminderMeeting reminderMeeting, int maxParticipantCount) throws IOException {
        String surl = this.getPrefixUrl() + "/" + meetingId + "?enterpriseId=" + enterpriseId + "&maxParticipant=" + maxParticipantCount;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)reminderMeeting);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result updateMeeting(String enterpriseId, String token, String meetingId, ReminderMeeting reminderMeeting) throws IOException {
        String surl = this.getPrefixUrl() + "/" + meetingId + "?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)reminderMeeting);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result deleteMeeting(String enterpriseId, String token, String meetingId) throws IOException {
        String surl = this.getPrefixUrl() + "/" + meetingId + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", null, null);
    }

    public Result<ReminderMeeting> getMeeting(String enterpriseId, String token, String meetingId) throws IOException {
        String surl = this.getPrefixUrl() + "/" + meetingId + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, ReminderMeeting.class);
    }

    public Result<ReminderMeeting[]> getAllMeeting(String enterpriseId, String token, long endTime) throws IOException {
        String surl = this.getPrefixUrl() + "?enterpriseId=" + enterpriseId + "&endTime=" + endTime;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, ReminderMeeting[].class);
    }

    public Result<Pager<ReminderMeeting>> getMeeting(String enterpriseId, String token, int page, int size, long endTime) throws IOException {
        String surl = this.getPrefixUrl() + "/page?enterpriseId=" + enterpriseId + "&pageIndex=" + page + "&pageSize=" + size + "&endTime=" + endTime;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        Result resp = HttpUtil.getResponse(surl, "GET", null, String.class);
        Result<Pager<ReminderMeeting>> result = new Result<Pager<ReminderMeeting>>();
        result.setSuccess(resp.isSuccess());
        result.setErrorStatus(resp.getErrorStatus());
        result.setErrorMsg(resp.getErrorMsg());
        if (resp.isSuccess() && StringUtils.isNotBlank((CharSequence)((CharSequence)resp.getData()))) {
            ObjectMapper objectMapper = new ObjectMapper();
            Pager pager = (Pager)objectMapper.readValue((String)resp.getData(), (TypeReference)new TypeReference<Pager<ReminderMeeting>>(){});
            result.setData(pager);
        }
        return result;
    }

    public Result<Pager> getMeetingByConfrenceNumber(String enterpriseId, String token, Integer pageIndex, Integer pageSize, String meetingRoomNumber) throws IOException {
        String surl = this.getPrefixUrl() + "/conference?enterpriseId=" + enterpriseId + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize + "&meetingRoomNumber=" + meetingRoomNumber;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, Pager.class);
    }

    private ReminderMeeting convert2ReminderMeeting(Map<String, Object> map) {
        ReminderMeeting reminderMeeting = new ReminderMeeting();
        reminderMeeting.setId((String)map.get("id"));
        return reminderMeeting;
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

