/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.enterpriseNemo;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.CallNumberInfo;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

public class CallNumberApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/{thirdId}/v1/callnumber";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public Result<CallNumberInfo> getCallNumberInfo(String enterpriseId, String token, String callNumber) throws IOException {
        String surl = CallNumberApi.getPrefixUrl() + "/" + callNumber + "?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)callNumber);
        String signature = signatureSample.computeSignature(jsonEntity, "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", jsonEntity, CallNumberInfo.class);
    }

    public static SignatureSample getSignatureSample() {
        return signatureSample;
    }

    public static void setSignatureSample(SignatureSample signatureSample) {
        CallNumberApi.signatureSample = signatureSample;
    }

    public static String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

