/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.enterpriseNemo;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.NemoDto;
import com.xylink.model.PageableNemoDto;
import com.xylink.model.UserDeviceDto;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;

public class EnterpriseNemoApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/buffet/nemos";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public Result<NemoDto[]> getEnterpriseNemos(String enterpriseId, String token) throws IOException {
        String surl = SDKConfigMgr.getServerHost() + prefixUrl + "?enterprise_id=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, NemoDto[].class);
    }

    public Result<NemoDto[]> addNemo2Enterprise(String enterpriseId, String token, List<UserDeviceDto> userDeviceDtos) throws IOException {
        String surl = SDKConfigMgr.getServerHost() + prefixUrl + "?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString(userDeviceDtos);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result<NemoDto[]> removeNemoFromEnterprise(String enterpriseId, String token, String nemoMumber) throws IOException {
        String surl = SDKConfigMgr.getServerHost() + prefixUrl + "?enterpriseId=" + enterpriseId + "&nemoNumber=" + nemoMumber;
        String jsonEntity = "";
        String signature = signatureSample.computeSignature(jsonEntity, "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", jsonEntity, String.class);
    }

    public Result<PageableNemoDto> getPageableEnterpriseNemos(String enterpriseId, String token, int page, int pageSize) throws IOException {
        String surl = SDKConfigMgr.getServerHost() + prefixUrl + "/page?enterprise_id=" + enterpriseId + "&page=" + page + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, NemoDto[].class);
    }
}

