/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.file;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.FileUploadVerifyReq;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

public class FileManageApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/file";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public Result uploadFace(String enterpriseId, String token, FileUploadVerifyReq fileUploadVerifyReq) throws IOException {
        String surl = this.getPrefixUrl() + "/upload/verify?enterpriseId=" + enterpriseId;
        String jsonEntity = objectMapper.writeValueAsString((Object)fileUploadVerifyReq);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, String.class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

