/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.user;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.ExternalLoginRequest;
import com.xylink.model.UserValidateResponse;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class UserValidateApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/user/";

    public UserValidateResponse userValidate(String enterpriseId, String token, ExternalLoginRequest externalLoginRequest) throws IOException {
        String surl = this.getPrefixUrl() + "validate?enterpriseId=" + enterpriseId;
        if (externalLoginRequest == null || StringUtils.isBlank((CharSequence)externalLoginRequest.getPassword()) || StringUtils.isBlank((CharSequence)externalLoginRequest.getUserPhone())) {
            return null;
        }
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)externalLoginRequest);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        Result userValidateResponseResult = HttpUtil.getResponse(surl, "POST", jsonEntity, UserValidateResponse.class);
        if (userValidateResponseResult.isSuccess()) {
            return (UserValidateResponse)userValidateResponseResult.getData();
        }
        throw new RuntimeException(userValidateResponseResult.getErrorStatus() + "");
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

